/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import snownee.kiwi.data.DataModule;

public class KiwiShapelessRecipe
extends ShapelessRecipe {
    private final boolean noContainers;
    private boolean trimmed;

    public KiwiShapelessRecipe(String string, CraftingBookCategory craftingBookCategory, ItemStack itemStack, NonNullList<Ingredient> nonNullList, boolean noContainers) {
        super(string, craftingBookCategory, itemStack, KiwiShapelessRecipe.mutableCopy(nonNullList));
        this.noContainers = noContainers;
    }

    public KiwiShapelessRecipe(ShapelessRecipe rawRecipe, boolean noContainers) {
        super(rawRecipe.getGroup(), rawRecipe.category(), rawRecipe.result, KiwiShapelessRecipe.mutableCopy((NonNullList<Ingredient>)rawRecipe.getIngredients()));
        this.noContainers = noContainers;
    }

    private static NonNullList<Ingredient> mutableCopy(NonNullList<Ingredient> list) {
        NonNullList copy = NonNullList.create();
        copy.addAll(list);
        return copy;
    }

    public boolean matches(CraftingInput input, Level level) {
        this.trim();
        return super.matches(input, level);
    }

    public boolean canCraftInDimensions(int i, int j) {
        this.trim();
        return super.canCraftInDimensions(i, j);
    }

    private void trim() {
        if (this.trimmed) {
            return;
        }
        this.trimmed = true;
        this.getIngredients().removeIf(Ingredient::isEmpty);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        if (this.noContainers) {
            return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        }
        return super.getRemainingItems((RecipeInput)input);
    }

    public RecipeSerializer<?> getSerializer() {
        return DataModule.SHAPELESS.get();
    }

    public static class Serializer
    implements RecipeSerializer<KiwiShapelessRecipe> {
        public static final MapCodec<KiwiShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)Codec.BOOL.optionalFieldOf("no_containers", (Object)false).forGetter(recipe -> recipe.noContainers)).apply((Applicative)i, KiwiShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KiwiShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<KiwiShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, KiwiShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static KiwiShapelessRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new KiwiShapelessRecipe((ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.streamCodec().decode((Object)buffer), buffer.readBoolean());
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, KiwiShapelessRecipe recipe) {
            RecipeSerializer.SHAPELESS_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            buffer.writeBoolean(recipe.noContainers);
        }
    }
}

