/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;

public class SmartKey
extends KeyMapping {
    private static final long SHORT_PRESS_MAX_MS = 200L;
    private static final long DOUBLE_PRESS_INTERVAL_MS = 200L;
    private static final long LONG_PRESS_MIN_MS = 400L;
    protected long pressSince = -1L;
    protected long lastShortPress = -1L;
    protected State state = State.Idle;
    private final BooleanSupplier onShortPress;
    private final BooleanSupplier onLongPress;
    private final BooleanSupplier onDoublePress;
    private final BooleanSupplier hasDoublePress;
    private final long longPressMinMs;

    private SmartKey(Builder builder) {
        super(builder.name, builder.type, builder.keyCode, builder.category);
        this.onShortPress = builder.onShortPress;
        this.onLongPress = builder.onLongPress;
        this.onDoublePress = builder.onDoublePress;
        this.hasDoublePress = builder.hasDoublePress;
        this.longPressMinMs = builder.longPressMinMs;
    }

    public void tick() {
        if (this.isUnbound()) {
            return;
        }
        long time = Util.getMillis();
        if (this.isDown()) {
            if (this.state != State.LongPress && this.pressSince != -1L && time - this.pressSince > this.longPressMinMs) {
                this.state = State.LongPress;
                this.onLongPress();
            }
        } else if (this.state == State.WaitingForDoublePress && time - this.lastShortPress > 200L) {
            this.onShortPress();
            this.pressSince = -1L;
            this.state = State.Idle;
        }
    }

    public void setDown(boolean isDown) {
        this.setDownWithResult(isDown);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setDownWithResult(boolean isDown) {
        boolean result;
        block8: {
            if (this.isDown() == isDown) {
                return false;
            }
            super.setDown(isDown);
            long time = Util.getMillis();
            result = false;
            if (isDown) {
                if (this.state == State.WaitingForDoublePress && time - this.lastShortPress < 200L) {
                    this.lastShortPress = -1L;
                    result = this.onDoublePress();
                    this.state = State.Idle;
                    break block8;
                } else {
                    this.pressSince = time;
                    this.state = State.ShortPress;
                    return false;
                }
            }
            if (this.state == State.ShortPress && time - this.pressSince < 200L) {
                this.lastShortPress = time;
                if (this.hasDoublePress()) {
                    this.state = State.WaitingForDoublePress;
                } else {
                    result = this.onShortPress();
                    this.state = State.Idle;
                }
            } else {
                this.state = State.Idle;
            }
        }
        this.pressSince = -1L;
        return result;
    }

    protected boolean hasDoublePress() {
        return this.onDoublePress != null && (this.hasDoublePress == null || this.hasDoublePress.getAsBoolean());
    }

    protected boolean onShortPress() {
        if (this.onShortPress != null) {
            return this.onShortPress.getAsBoolean();
        }
        return false;
    }

    protected boolean onLongPress() {
        if (this.onLongPress != null) {
            return this.onLongPress.getAsBoolean();
        }
        return false;
    }

    protected boolean onDoublePress() {
        if (this.onDoublePress != null) {
            return this.onDoublePress.getAsBoolean();
        }
        return false;
    }

    public static class Builder {
        private final String name;
        private final String category;
        private InputConstants.Type type = InputConstants.Type.KEYSYM;
        private int keyCode = -1;
        private BooleanSupplier onShortPress;
        private BooleanSupplier onLongPress;
        private BooleanSupplier onDoublePress;
        private BooleanSupplier hasDoublePress;
        private long longPressMinMs = 400L;

        public Builder(String name, String category) {
            this.name = name;
            this.category = category;
        }

        public Builder key(InputConstants.Key key) {
            this.type = key.getType();
            this.keyCode = key.getValue();
            return this;
        }

        public Builder onShortPress(BooleanSupplier onShortPress) {
            this.onShortPress = onShortPress;
            return this;
        }

        public Builder onLongPress(BooleanSupplier onLongPress) {
            this.onLongPress = onLongPress;
            return this;
        }

        public Builder onDoublePress(BooleanSupplier onDoublePress) {
            this.onDoublePress = onDoublePress;
            return this;
        }

        public Builder hasDoublePress(BooleanSupplier hasDoublePress) {
            this.hasDoublePress = hasDoublePress;
            return this;
        }

        public SmartKey build() {
            return new SmartKey(this);
        }

        public Builder longPressMinMs(long longPressMinMs) {
            this.longPressMinMs = longPressMinMs;
            return this;
        }
    }

    public static enum State {
        Idle,
        ShortPress,
        WaitingForDoublePress,
        LongPress;

    }
}

