/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.inventory.slot.BaseItemStackHandlerSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ExtendedContainerMenu
extends BaseContainerMenu {
    protected ExtendedContainerMenu(MenuType<?> menu, int id, BlockPos pos) {
        super(menu, id, pos);
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        boolean flag = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverse ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int j = itemstack.getCount() + stack.getCount();
                int maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize());
                if (slot instanceof BaseItemStackHandlerSlot) {
                    maxSize = slot.getMaxStackSize(stack);
                }
                if (j <= maxSize) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < maxSize) {
                    stack.shrink(maxSize - itemstack.getCount());
                    itemstack.setCount(maxSize);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        }
        if (!stack.isEmpty()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    int maxSize = Math.min(slot1.getMaxStackSize(), stack.getMaxStackSize());
                    if (stack.getCount() > maxSize) {
                        slot1.setByPlayer(stack.split(maxSize));
                        slot1.setChanged();
                        break;
                    }
                    slot1.setByPlayer(stack.split(stack.getCount()));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }
}

