/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

public final class ColorHelper {
    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static int[] hexToRGB(int hex) {
        int[] colors = new int[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF};
        return colors;
    }

    private static float interpolate(float a, float b, float proportion) {
        return a + (b - a) * proportion;
    }

    public static int interpolateColor(int a, int b, float proportion) {
        float[] hsva = new float[3];
        float[] hsvb = new float[3];
        ColorHelper.rgbToHSB(a >> 16 & 0xFF, a >> 8 & 0xFF, a & 0xFF, hsva);
        ColorHelper.rgbToHSB(b >> 16 & 0xFF, b >> 8 & 0xFF, b & 0xFF, hsvb);
        for (int i = 0; i < 3; ++i) {
            hsvb[i] = ColorHelper.interpolate(hsva[i], hsvb[i], proportion);
        }
        float alpha = ColorHelper.interpolate(a >> 24 & 0xFF, b >> 24 & 0xFF, proportion);
        return ColorHelper.hsbToRGB(hsvb[0], hsvb[1], hsvb[2]) | (int)(alpha * 255.0f) & 0xFF;
    }

    public static int saturate(int color, float saturation) {
        float[] hsv = new float[3];
        ColorHelper.rgbToHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsv);
        hsv[1] = hsv[1] * saturation;
        return ColorHelper.hsbToRGB(hsv[0], hsv[1], hsv[2]);
    }

    public static int hexToIntWithAlpha(int hex, int alpha) {
        return alpha << 24 | hex & 0xFFFFFF;
    }

    public static int calcAlpha(double current, double max) {
        return (int)((max - current) / max) * 255;
    }

    public static int hsbToRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] rgbToHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        if (b > (cmax = Math.max(r, g))) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }
}

