/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.power;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.IOTrackerSelfTimed;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.lib.IValueHashable;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class OPStorage
implements INBTSerializable<CompoundTag>,
IValueHashable<ComparableValue>,
IMCDataSerializable,
IOPStorage {
    protected Runnable changeListener;
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected IOTracker ioTracker;
    protected boolean allowExtract = true;
    protected boolean allowReceive = true;

    public OPStorage(long capacity) {
        this(capacity, capacity);
    }

    public OPStorage(BlockEntity tile, long capacity) {
        this(capacity, capacity);
        this.setChangeListener(() -> ((BlockEntity)tile).setChanged());
    }

    public OPStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public OPStorage(BlockEntity tile, long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
        this.setChangeListener(() -> ((BlockEntity)tile).setChanged());
    }

    public OPStorage(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public OPStorage(BlockEntity tile, long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.setChangeListener(() -> ((BlockEntity)tile).setChanged());
    }

    public OPStorage setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public OPStorage setIOMode(boolean allowExtract, boolean allowReceive) {
        this.allowExtract = allowExtract;
        this.allowReceive = allowReceive;
        return this;
    }

    public OPStorage setExtractOnly() {
        return this.setIOMode(true, false);
    }

    public OPStorage setReceiveOnly() {
        return this.setIOMode(false, true);
    }

    public OPStorage setIOMode(boolean inputOutput) {
        return this.setIOMode(!inputOutput, inputOutput);
    }

    @Override
    public long receiveOP(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.getMaxOPStored() - this.energy, Math.min(this.maxReceive(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            if (this.ioTracker != null) {
                this.ioTracker.energyInserted(energyReceived);
            }
            if (energyReceived != 0L) {
                this.markDirty();
            }
        }
        return energyReceived;
    }

    @Override
    public long extractOP(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            if (this.ioTracker != null) {
                this.ioTracker.energyExtracted(energyExtracted);
            }
            if (energyExtracted != 0L) {
                this.markDirty();
            }
        }
        return energyExtracted;
    }

    @Override
    public long getOPStored() {
        return this.energy;
    }

    @Override
    public long getMaxOPStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.allowExtract && this.maxExtract() > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.allowReceive && this.maxReceive() > 0L;
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if (amount > this.getMaxOPStored() - this.energy) {
            amount = this.getMaxOPStored() - this.energy;
        } else if (amount < -this.energy) {
            amount = -this.energy;
        }
        this.energy += amount;
        if (this.ioTracker != null) {
            this.ioTracker.energyModified(amount);
        }
        if (amount != 0L) {
            this.markDirty();
        }
        return Math.abs(amount);
    }

    @Override
    public long maxExtract() {
        return this.maxExtract;
    }

    @Override
    public long maxReceive() {
        return this.maxReceive;
    }

    public OPStorage setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public OPStorage setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public OPStorage setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public OPStorage setMaxTransfer(long maxTransfer) {
        this.maxReceive = this.maxExtract = maxTransfer;
        return this;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        this.smartWrite("energy", this.energy, compound);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.energy = this.smartRead("energy", nbt);
    }

    private void smartWrite(String name, long value, CompoundTag compound) {
        if (value > Integer.MAX_VALUE) {
            compound.putLong(name, value);
        } else {
            compound.putInt(name, (int)value);
        }
    }

    private long smartRead(String name, CompoundTag compound) {
        Tag tag = compound.get(name);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsLong();
        }
        return 0L;
    }

    public void markDirty() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        output.writeVarLong(this.energy);
        output.writeVarLong(this.capacity);
        output.writeVarLong(this.maxReceive);
        output.writeVarLong(this.maxExtract);
        output.writeBoolean(this.ioTracker != null);
        if (this.ioTracker != null) {
            output.writeVarLong(this.ioTracker.currentInput());
            output.writeVarLong(this.ioTracker.currentOutput());
        }
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        this.energy = input.readVarLong();
        this.capacity = input.readVarLong();
        this.maxReceive = input.readVarLong();
        this.maxExtract = input.readVarLong();
        if (input.readBoolean()) {
            if (this.ioTracker == null) {
                this.ioTracker = new IOTrackerSelfTimed();
            }
            this.ioTracker.syncClientValues(input.readVarLong(), input.readVarLong());
        } else if (this.ioTracker != null) {
            this.ioTracker = null;
        }
    }

    @Override
    public ComparableValue getValueHash() {
        return new ComparableValue(this);
    }

    @Override
    public boolean checkValueHash(Object vh) {
        if (vh instanceof ComparableValue) {
            boolean mainCheck;
            ComparableValue v = (ComparableValue)vh;
            boolean bl = mainCheck = v.energy == this.energy && v.capacity == this.capacity && v.maxExtract == this.maxExtract && v.maxReceive == this.maxReceive;
            if (this.ioTracker != null) {
                return mainCheck && v.currentInput == this.ioTracker.currentInput() && v.currentOutput == this.ioTracker.currentOutput();
            }
            return mainCheck;
        }
        return false;
    }

    public void setIOTracker(@Nullable IOTracker ioTracker) {
        this.ioTracker = ioTracker;
    }

    @Override
    @Nullable
    public IOInfo getIOInfo() {
        return this.ioTracker;
    }

    protected static class ComparableValue {
        private final long energy;
        private final long capacity;
        private final long maxReceive;
        private final long maxExtract;
        private long currentInput = 0L;
        private long currentOutput = 0L;

        public ComparableValue(OPStorage storage) {
            this.energy = storage.energy;
            this.capacity = storage.capacity;
            this.maxReceive = storage.maxReceive;
            this.maxExtract = storage.maxExtract;
            if (storage.ioTracker != null) {
                this.currentInput = storage.ioTracker.currentInput();
                this.currentOutput = storage.ioTracker.currentOutput();
            }
        }
    }
}

