/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.api.event.TileBCoreInitEvent;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileCapabilityManager;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.TileDataManager;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileBCore
extends BlockEntity
implements IDataManagerProvider,
IDataRetainingTile,
Nameable {
    public static final Logger LOGGER = LogManager.getLogger();
    protected boolean playerAccessTracking = false;
    protected TileCapabilityManager capManager = new TileCapabilityManager(this);
    protected TileDataManager<TileBCore> dataManager = new TileDataManager<TileBCore>(this);
    private Map<Integer, BiConsumer<MCDataInput, ServerPlayer>> serverPacketHandlers = new HashMap<Integer, BiConsumer<MCDataInput, ServerPlayer>>();
    protected Map<String, INBTSerializable<CompoundTag>> savedItemDataObjects = new HashMap<String, INBTSerializable<CompoundTag>>();
    protected Map<String, INBTSerializable<CompoundTag>> savedDataObjects = new HashMap<String, INBTSerializable<CompoundTag>>();
    private Map<Integer, Consumer<MCDataInput>> clientPacketHandlers = new HashMap<Integer, Consumer<MCDataInput>>();
    private boolean debugOutputEnabled = false;
    private ManagedBool debugEnabled = null;
    private List<Runnable> tickables = new ArrayList<Runnable>();
    private ManagedEnum<IRSSwitchable.RSMode> rsControlMode = this instanceof IRSSwitchable ? this.register(new ManagedEnum<IRSSwitchable.RSMode>("rs_mode", IRSSwitchable.RSMode.ALWAYS_ACTIVE, DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL)) : null;
    private ManagedBool rsPowered = this instanceof IRSSwitchable ? this.register(new ManagedBool("rs_powered", false, DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE)) : null;
    private String customName = "";
    private Set<Player> accessingPlayers = new HashSet<Player>();
    private int tick = 0;

    public TileBCore(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        NeoForge.EVENT_BUS.post((Event)new TileBCoreInitEvent(this));
    }

    @Override
    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public TileCapabilityManager getCapManager() {
        return this.capManager;
    }

    protected static <T, BE extends TileBCore> void capability(RegisterCapabilitiesEvent event, Supplier<BlockEntityType<BE>> type, BlockCapability<T, Direction> capability) {
        event.registerBlockEntity(capability, type.get(), (tile, side) -> tile.getCapManager().getCapability(capability, (Direction)side));
    }

    protected static <BE extends TileBCore> void energyCapability(RegisterCapabilitiesEvent event, Supplier<BlockEntityType<BE>> type) {
        event.registerBlockEntity(CapabilityOP.BLOCK, type.get(), (tile, side) -> tile.getCapManager().getCapability(CapabilityOP.BLOCK, (Direction)side));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, type.get(), (tile, side) -> tile.getCapManager().getCapability(CapabilityOP.BLOCK, (Direction)side));
    }

    public <M extends IManagedData> M register(M managedData) {
        return this.dataManager.register(managedData);
    }

    public void tick() {
        this.tickables.forEach(Runnable::run);
        this.detectAndSendChanges(false);
        ++this.tick;
    }

    public void detectAndSendChanges(boolean containerListeners) {
        if (this.level != null && !this.level.isClientSide) {
            if (containerListeners) {
                this.dataManager.detectAndSendChangesToListeners(this.getAccessingPlayers());
                this.capManager.detectAndSendChangesToListeners(this.getAccessingPlayers());
            } else {
                this.dataManager.detectAndSendChanges();
                this.capManager.detectAndSendChanges();
            }
        }
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = super.getUpdateTag(provider);
        this.dataManager.writeSyncNBT(provider, compound);
        this.writeExtraNBT(provider, compound);
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.dataManager.readSyncNBT(provider, pkt.getTag());
        this.readExtraNBT(provider, pkt.getTag());
    }

    public PacketCustom createServerBoundPacket(int id) {
        AbstractContainerMenu container;
        Player player = BrandonsCore.proxy.getClientPlayer();
        if (player != null && (container = player.containerMenu) instanceof ContainerBCTile && ((ContainerBCTile)container).tile == this) {
            PacketCustom packet = ((ContainerBCTile)container).createServerBoundPacket(1);
            packet.writeByte((int)((byte)id));
            return packet;
        }
        return new PacketCustom(BCoreNetwork.CHANNEL_NAME, 99, this.getLevel().registryAccess());
    }

    public void sendPacketToServer(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createServerBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        packet.sendToServer();
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (this.serverPacketHandlers.containsKey(id)) {
            this.serverPacketHandlers.get(id).accept(data, client);
        }
    }

    public PacketCustom createClientBoundPacket(int id) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL_NAME, 2, this.getLevel().registryAccess());
        packet.writePos(this.worldPosition);
        packet.writeByte((int)((byte)id));
        return packet;
    }

    public PacketCustom sendPacketToClient(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        return packet;
    }

    public void sendPacketToClient(ServerPlayer player, Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToPlayer(player);
    }

    public void sendPacketToClients(Collection<Player> players, Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        this.sendPacketToClients(players, packet);
    }

    public void sendPacketToClients(Collection<Player> players, PacketCustom packet) {
        players.stream().filter(e -> e instanceof ServerPlayer).map(e -> (ServerPlayer)e).forEach(arg_0 -> ((PacketCustom)packet).sendToPlayer(arg_0));
    }

    public void sendPacketToChunk(Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToChunk((BlockEntity)this);
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (this.clientPacketHandlers.containsKey(id)) {
            this.clientPacketHandlers.get(id).accept(data);
        }
    }

    public void setClientSidePacketHandler(int packetId, Consumer<MCDataInput> handler) {
        this.clientPacketHandlers.put(packetId, handler);
    }

    public void setServerSidePacketHandler(int packetId, BiConsumer<MCDataInput, ServerPlayer> handler) {
        this.serverPacketHandlers.put(packetId, handler);
    }

    public void updateBlock() {
        BlockState state = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
    }

    public void dirtyBlock() {
        LevelChunk chunk = this.level.getChunkAt(this.getBlockPos());
        chunk.setUnsaved(true);
    }

    public <T extends Runnable> T addTickable(T runnable) {
        this.tickables.add(runnable);
        return runnable;
    }

    public boolean removeTickable(Runnable runnable) {
        return this.tickables.remove(runnable);
    }

    @Override
    public void writeToItemStack(HolderLookup.Provider provider, CompoundTag nbt, boolean willHarvest) {
        this.dataManager.writeToStackNBT(provider, nbt);
        this.savedItemDataObjects.forEach((tagName, serializable) -> nbt.put(tagName, serializable.serializeNBT(provider)));
        CompoundTag capTags = this.capManager.serialize(true);
        if (!capTags.isEmpty()) {
            nbt.put("bc_caps", (Tag)capTags);
        }
        this.writeExtraTileAndStack(provider, nbt);
    }

    @Override
    public void readFromItemStack(HolderLookup.Provider provider, CompoundTag nbt) {
        this.dataManager.readFromStackNBT(provider, nbt);
        this.savedItemDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT(provider, (Tag)nbt.getCompound(tagName)));
        if (nbt.contains("bc_caps")) {
            this.capManager.deserialize(provider, nbt.getCompound("bc_caps"));
        }
        this.readExtraTileAndStack(provider, nbt);
    }

    public void writeExtraNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        CompoundTag capTags = this.capManager.serialize(false);
        if (!capTags.isEmpty()) {
            nbt.put("bc_caps", (Tag)capTags);
        }
        if (!this.customName.isEmpty()) {
            nbt.putString("custom_name", this.customName);
        }
        this.savedDataObjects.forEach((tagName, serializable) -> nbt.put(tagName, serializable.serializeNBT(provider)));
        this.writeExtraTileAndStack(provider, nbt);
    }

    public void readExtraNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("bc_caps")) {
            this.capManager.deserialize(provider, nbt.getCompound("bc_caps"));
        }
        if (nbt.contains("custom_name", 8)) {
            this.customName = nbt.getString("custom_name");
        }
        this.savedDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT(provider, (Tag)nbt.getCompound(tagName)));
        this.readExtraTileAndStack(provider, nbt);
    }

    public void writeExtraTileAndStack(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    public void readExtraTileAndStack(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    protected final void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        this.dataManager.writeToNBT(provider, nbt);
        this.writeExtraNBT(provider, nbt);
    }

    protected final void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.dataManager.readFromNBT(provider, nbt);
        this.readExtraNBT(provider, nbt);
        this.onTileLoaded();
    }

    public void onTileLoaded() {
    }

    public void setSavedDataObject(String tagName, INBTSerializable<CompoundTag> dataObject) {
        this.savedDataObjects.put(tagName, dataObject);
    }

    public void setItemSavedDataObject(String tagName, INBTSerializable<CompoundTag> dataObject) {
        this.savedItemDataObjects.put(tagName, dataObject);
    }

    public long sendEnergyToAll(long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += this.sendEnergyTo(Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public long sendEnergyTo(long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.getOpposite(), false);
        }
        return 0L;
    }

    public static long sendEnergyTo(LevelReader world, BlockPos pos, long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        BlockEntity tile = world.getBlockEntity(pos.relative(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.getOpposite(), false);
        }
        return 0L;
    }

    public static long sendEnergyToAll(LevelReader world, BlockPos pos, long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += TileBCore.sendEnergyTo(world, pos, Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public void installIOTracker(OPStorage storage) {
        storage.setIOTracker(this.addTickable(new IOTracker()));
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, ManagedBool chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, chargeItem::get);
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, boolean chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, () -> chargeItem);
    }

    private void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, Supplier<Boolean> chargeItem) {
        if (itemHandler instanceof TileItemStackHandler) {
            ((TileItemStackHandler)itemHandler).setSlotValidator(slot, stack -> (Boolean)chargeItem.get() != false ? EnergyUtils.canReceiveEnergy(stack) : EnergyUtils.canExtractEnergy(stack));
        }
        if (EffectiveSide.get().isServer()) {
            this.addTickable(() -> {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.isEmpty()) {
                    if (((Boolean)chargeItem.get()).booleanValue()) {
                        EnergyUtils.transferEnergy(storage, stack);
                    } else {
                        EnergyUtils.transferEnergy(stack, storage);
                    }
                }
            });
        }
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public IRSSwitchable.RSMode getRSMode() {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return this.rsControlMode.get();
    }

    public void setRSMode(IRSSwitchable.RSMode mode) {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        this.rsControlMode.set(mode);
    }

    public void cycleRSMode(boolean reverse) {
        this.rsControlMode.set(this.rsControlMode.get().next(reverse));
    }

    public void onNeighborChange(BlockPos neighbor) {
        if (this instanceof IRSSwitchable) {
            boolean lastSignal = this.rsPowered.get();
            this.rsPowered.set(this.level.hasNeighborSignal(this.worldPosition));
            if (this.rsPowered.get() != lastSignal) {
                this.onSignalChange(this.rsPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }

    public boolean isTileEnabled() {
        if (this instanceof IRSSwitchable) {
            return this.rsControlMode.get().canRun(this.rsPowered.get());
        }
        return true;
    }

    public boolean hasRSSignal() {
        return this.level.hasNeighborSignal(this.getBlockPos());
    }

    public int getRSSignal() {
        return this.level.getBestNeighborSignal(this.getBlockPos());
    }

    public Component getName() {
        if (this.hasCustomName()) {
            return Component.literal((String)this.customName);
        }
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public boolean hasCustomName() {
        return !this.customName.isEmpty();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName.isEmpty() ? null : this.getName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void enablePlayerAccessTracking(boolean playerAccessTracking) {
        this.playerAccessTracking = playerAccessTracking;
    }

    public Set<Player> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt0$temp = e.containerMenu;
            if (!(patt0$temp instanceof ContainerBCTile)) return true;
            ContainerBCTile container = (ContainerBCTile)patt0$temp;
            if (container.tile == this) return false;
            return true;
        });
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(Player player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(Player player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt0$temp = e.containerMenu;
            if (!(patt0$temp instanceof ContainerBCTile)) return true;
            ContainerBCTile container = (ContainerBCTile)patt0$temp;
            if (container.tile == this) return false;
            return true;
        });
    }

    public int posSeed() {
        return (int)this.worldPosition.asLong();
    }

    protected void enableTileDebug() {
        this.debugEnabled = new ManagedBool("tile.debugging.enabled", false, DataFlags.SYNC_TILE);
        this.register(this.debugEnabled);
    }

    public boolean toggleDebugOutput(Player player) {
        if (this.debugEnabled == null) {
            return false;
        }
        this.debugEnabled.invert();
        player.sendSystemMessage((Component)Component.literal((String)("Debug is now " + (this.debugEnabled.get() ? "Enabled (Check Server/Client console)" : "Disabled"))));
        return true;
    }

    public void debug(Object text) {
        if (this.debugEnabled()) {
            LOGGER.info("TileDebug:" + String.valueOf(this.getBlockPos()) + ", " + String.valueOf(this.getLevel().dimension().location()) + ": " + String.valueOf(text));
        }
    }

    public boolean debugEnabled() {
        return this.debugEnabled != null && this.debugEnabled.get();
    }
}

