/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.shader;

import codechicken.lib.render.shader.CCShaderInstance;
import codechicken.lib.render.shader.CCUniform;
import codechicken.lib.util.ClientUtils;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.shader.ChaosEntityShader;
import com.brandon3055.brandonscore.client.shader.ContribShader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;

public class BCShaders {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    public static final ChaosEntityShader CHAOS_ENTITY_SHADER = new ChaosEntityShader("chaos_entity", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> {
        LocalPlayer player = Minecraft.getInstance().player;
        e.getTimeUniform().glUniform1f((float)ClientUtils.getRenderTime());
        e.getYawUniform().glUniform1f((float)((double)player.getYRot() * 0.017453292519943));
        e.getPitchUniform().glUniform1f((float)(-((double)player.getXRot() * 0.017453292519943)));
    });
    public static final ContribShader CONTRIB_BASE_SHADER = new ContribShader("contributor/contrib_base", DefaultVertexFormat.NEW_ENTITY);
    public static final ContribShader WINGS_WEB_SHADER = new ContribShader("contributor/wings_web", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    public static final ContribShader WINGS_BONE_SHADER = new ContribShader("contributor/wings_bone", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    public static final ContribShader VET_BADGE_SHADER = new ContribShader("contributor/vet_badge", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    public static final ContribShader BADGE_OUTLINE_SHADER = new ContribShader("contributor/badge_outline", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    public static final ContribShader BADGE_CORE_SHADER = new ContribShader("contributor/patreon_core", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 20.0)));
    public static final ContribShader BADGE_FOIL_SHADER = new ContribShader("contributor/badge_foil", DefaultVertexFormat.NEW_ENTITY).onShaderApplied(e -> e.getTimeUniform().glUniform1f((float)(ClientUtils.getRenderTime() / 40.0)));
    public static CCShaderInstance energyBarShader;
    public static CCUniform energyBarTime;
    public static CCUniform energyBarCharge;
    public static CCUniform energyBarEPos;
    public static CCUniform energyBarESize;
    public static CCUniform energyBarScreenSize;
    public static CCShaderInstance posColourTexAlpha0;

    public static void init(IEventBus modBus) {
        LOCK.lock();
        CONTRIB_BASE_SHADER.register(modBus);
        WINGS_WEB_SHADER.register(modBus);
        WINGS_BONE_SHADER.register(modBus);
        VET_BADGE_SHADER.register(modBus);
        CHAOS_ENTITY_SHADER.register(modBus);
        BADGE_OUTLINE_SHADER.register(modBus);
        BADGE_CORE_SHADER.register(modBus);
        BADGE_FOIL_SHADER.register(modBus);
        modBus.addListener(BCShaders::onRegisterShaders);
    }

    private static void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"brandonscore", (String)"energy_bar"), (VertexFormat)DefaultVertexFormat.POSITION), e -> {
            energyBarShader = (CCShaderInstance)e;
            energyBarTime = energyBarShader.getUniform("time");
            energyBarCharge = energyBarShader.getUniform("charge");
            energyBarEPos = energyBarShader.getUniform("ePos");
            energyBarESize = energyBarShader.getUniform("eSize");
            energyBarScreenSize = energyBarShader.getUniform("screenSize");
            energyBarShader.onApply(() -> energyBarTime.glUniform1f((float)BCClientEventHandler.elapsedTicks / 10.0f));
        });
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"brandonscore", (String)"position_color_tex_alpha0"), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR), e -> {
            posColourTexAlpha0 = (CCShaderInstance)e;
        });
    }
}

