/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.inventory.ContainerPlayerAccess;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.EventBus;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.apache.commons.io.IOUtils;

public class BCUtilCommands {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bcore_util").then(BCUtilCommands.registerNBT())).then(BCUtilCommands.registerStackString())).then(BCUtilCommands.registerNoClip())).then(BCUtilCommands.registerUUID())).then(BCUtilCommands.registerDumpEvents())).then(BCUtilCommands.registerEggify())).then(BCUtilCommands.registerPlaceMultiBlock())).then(BCUtilCommands.reloadContributors())).then(BCUtilCommands.registerTileDebug());
        if (BrandonsCore.inDev) {
            builder.then(BCUtilCommands.registerDev1());
            builder.then(BCUtilCommands.registerDev2());
        }
        dispatcher.register(builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerTileDebug() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"debug_tile").requires(cs -> cs.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            TileBCore tile;
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockEntity patt0$temp = player.level().getBlockEntity(pos);
            if (!(patt0$temp instanceof TileBCore) || !(tile = (TileBCore)patt0$temp).toggleDebugOutput((Player)player)) {
                player.sendSystemMessage((Component)Component.literal((String)"This tile does not support Brandon's Core Debugging"));
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"multiblock", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(MultiBlockManager.getRegisteredIds(), (SuggestionsBuilder)builder)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"multiblock"), Vec3.ZERO))).then(Commands.argument((String)"rotation", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"multiblock"), Vec3Argument.getVec3((CommandContext)context, (String)"rotation"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> reloadContributors() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"reset_contrib_handler").requires(cs -> cs.hasPermission(3))).executes(context -> {
            ContributorHandler.reload();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Reset complete"), false);
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerPlaceMultiBlock() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"place_multiblock").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"multiblock", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(MultiBlockManager.getRegisteredIds(), (SuggestionsBuilder)builder)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"multiblock"), Vec3.ZERO))).then(Commands.argument((String)"rotation", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"multiblock"), Vec3Argument.getVec3((CommandContext)context, (String)"rotation"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerNBT() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"nbt").requires(cs -> cs.hasPermission(0))).executes(context -> BCUtilCommands.functionNBT((CommandSourceStack)context.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerStackString() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"stack_string").then(((LiteralArgumentBuilder)Commands.literal((String)"from_string").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"give-to", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"stack-string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BCUtilCommands.functionFromStackString((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"give-to"), StringArgumentType.getString((CommandContext)ctx, (String)"stack-string"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"to_string").requires(cs -> cs.hasPermission(0))).then(Commands.literal((String)"id_only").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, false, false)))).then(Commands.literal((String)"id_nbt").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, true, false)))).then(Commands.literal((String)"id_count").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, false, false)))).then(Commands.literal((String)"id_nbt_count").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, true, false)))).then(Commands.literal((String)"id_nbt_capabilities").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, true, true)))).executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, true, true)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerRegenChunk() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"regenchunk").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> BCUtilCommands.regenChunk((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerNoClip() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"noclip").requires(cs -> cs.hasPermission(3))).executes(context -> BCUtilCommands.toggleNoClip((CommandSourceStack)context.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerUUID() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"uuid").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> BCUtilCommands.getUUID((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"target"))))).executes(ctx -> BCUtilCommands.getUUID((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).getPlayerOrException()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerPlayerAccess() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player_access").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"target", reader -> StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(BCUtilCommands.accessiblePlayers((CommandSourceStack)context.getSource()).values().stream().map(GameProfile::getName), (SuggestionsBuilder)builder)).executes(context -> BCUtilCommands.playerAccess((CommandSourceStack)context.getSource(), (String)context.getArgument("target", String.class))))).then(Commands.literal((String)"list").executes(context -> BCUtilCommands.playerAccess((CommandSourceStack)context.getSource(), null)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDumpEvents() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dump_event_listeners").requires(cs -> cs.hasPermission(0))).executes(ctx -> BCUtilCommands.dumpEventListeners((CommandSourceStack)ctx.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerEggify() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"eggify").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).executes(ctx -> BCUtilCommands.eggify((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntity((CommandContext)ctx, (String)"target"))));
    }

    private static int functionNBT(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"You are not holding an item!")).create();
        }
        Tag compound = stack.saveOptional((HolderLookup.Provider)player.registryAccess());
        LogHelperBC.logNBT((CompoundTag)compound);
        LogHelperBC.info(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, arg_0 -> BCUtilCommands.lambda$functionNBT$39((Player)player, arg_0));
        return 0;
    }

    private static int functionToStackString(CommandSourceStack source, boolean count, boolean nbt, boolean caps) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"You are not holding an item!")).create();
        }
        String returnString = StringyStacks.toString(stack, nbt, count, caps, (HolderLookup.Provider)player.registryAccess());
        ChatHelper.sendMessage((Player)player, (Component)Component.literal((String)"# The following is stack string for the held stack (click to copy) #").withStyle(ChatFormatting.BLUE));
        MutableComponent textComponent = returnString.length() > 64 ? Component.literal((String)(returnString.substring(0, 64) + "... ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"(Mouseover for full)").withStyle(ChatFormatting.DARK_AQUA).withStyle(ChatFormatting.UNDERLINE)) : Component.literal((String)returnString).withStyle(ChatFormatting.GOLD);
        textComponent.setStyle(textComponent.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy to clipboard").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)("\n" + returnString)).withStyle(ChatFormatting.GRAY)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, returnString)));
        ChatHelper.sendMessage((Player)player, (Component)textComponent);
        StringyStacks.LOGGER.info(returnString);
        return 0;
    }

    private static int functionFromStackString(CommandSourceStack source, ServerPlayer player, String stackString) throws CommandSyntaxException {
        ItemStack stack = StringyStacks.fromString(stackString, null);
        if (stack == null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid item string. You may find more details in the server console.")).create();
        }
        boolean flag = player.getInventory().add(stack);
        if (flag && stack.isEmpty()) {
            stack.setCount(1);
            player.level().playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity itementity = player.drop(stack, false);
            if (itementity != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)player);
            }
        }
        return 0;
    }

    private static int regenChunk(CommandSourceStack source, int rad) throws CommandSyntaxException {
        for (int xOffset = -rad; xOffset <= rad; ++xOffset) {
            for (int yOffset = -rad; yOffset <= rad; ++yOffset) {
                ServerLevel world = source.getLevel();
                ServerPlayer player = source.getPlayerOrException();
                ServerChunkCache chunkProviderServer = world.getChunkSource();
                ChunkGenerator chunkGenerator = chunkProviderServer.getGenerator();
            }
        }
        return 0;
    }

    private static int toggleNoClip(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        boolean enabled = BCEventHandler.noClipPlayers.contains(player.getUUID());
        if (enabled) {
            BCEventHandler.noClipPlayers.remove(player.getUUID());
            BCoreNetwork.sendNoClip(player, false);
            source.sendSuccess(() -> Component.literal((String)"NoClip Disabled!"), true);
        } else {
            BCEventHandler.noClipPlayers.add(player.getUUID());
            BCoreNetwork.sendNoClip(player, true);
            source.sendSuccess(() -> Component.literal((String)"NoClip Enabled!"), true);
        }
        return 0;
    }

    private static int getUUID(CommandSourceStack source, ServerPlayer player) {
        MutableComponent comp = Component.literal((String)(player.getName().getString() + "'s UUID: " + String.valueOf(ChatFormatting.UNDERLINE) + String.valueOf(player.getUUID())));
        comp.setStyle(comp.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, player.getUUID().toString())));
        comp.setStyle(comp.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy to clipboard"))));
        source.sendSuccess(() -> comp, true);
        return 0;
    }

    public static int dumpEventListeners(CommandSourceStack source) throws CommandSyntaxException {
        HashMap eventListenerMap = new HashMap();
        BCUtilCommands.dumpBus("EVENT_BUS", (EventBus)NeoForge.EVENT_BUS, eventListenerMap);
        StringBuilder builder = new StringBuilder("\n");
        for (String bus : eventListenerMap.keySet()) {
            builder.append("Dumping listeners for bus: ").append(bus).append("\n");
            Map busListeners = (Map)eventListenerMap.get(bus);
            ArrayList sortedClasses = Lists.newArrayList(busListeners.keySet());
            sortedClasses.sort(Comparator.comparing(Class::getName));
            for (Class eventClass : sortedClasses) {
                List listenerList = (List)busListeners.get(eventClass);
                listenerList.sort(Comparator.comparingInt(value -> ((EventPriority)value.key()).ordinal()));
                builder.append("    Handlers for event: ").append(eventClass).append("\n");
                for (Pair listener : listenerList) {
                    Method m = (Method)listener.value();
                    builder.append("        ").append(listener.key()).append(" ").append(m.getDeclaringClass().getName()).append(" ").append(m.getName()).append("(").append(BCUtilCommands.separateWithCommas(m.getParameterTypes())).append(")\n");
                }
                builder.append("\n");
            }
        }
        LogHelperBC.info(builder.toString());
        for (String s : builder.toString().split("\n")) {
            source.sendSuccess(() -> Component.literal((String)s), true);
        }
        return 0;
    }

    private static String separateWithCommas(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < types.length; ++j) {
            sb.append(types[j].getTypeName());
            if (j >= types.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static void dumpBus(String name, EventBus bus, Map<String, Map<Class<?>, List<Pair<EventPriority, Method>>>> baseMap) throws CommandSyntaxException {
        Map map = baseMap.computeIfAbsent(name, eventBus -> new HashMap());
        try {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String)"listeners");
            for (Object obj : listeners.keySet()) {
                for (Method method : obj.getClass().getMethods()) {
                    SubscribeEvent anno = method.getAnnotation(SubscribeEvent.class);
                    if (anno == null) continue;
                    for (Class<?> parameter : method.getParameterTypes()) {
                        if (!Event.class.isAssignableFrom(parameter)) continue;
                        map.computeIfAbsent(parameter, aClass -> new ArrayList()).add(new Pair<EventPriority, Method>(anno.priority(), method));
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new SimpleCommandExceptionType((Message)Component.literal((String)e.getMessage())).create();
        }
    }

    private static int eggify(CommandContext<CommandSourceStack> ctx, Entity target) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Entity entity = target;
        if (entity == null) {
            player.sendSystemMessage((Component)Component.literal((String)"You must be looking at an entity!"));
            return 1;
        }
        ItemStack spawnEgg = new ItemStack((ItemLike)SpawnEggItem.byId((EntityType)entity.getType()));
        CompoundTag data = new CompoundTag();
        entity.save(data);
        data.remove("Pos");
        data.remove("Motion");
        data.remove("Rotation");
        data.remove("FallDistance");
        data.remove("Fire");
        data.remove("Air");
        data.remove("OnGround");
        data.remove("Dimension");
        data.remove("Invulnerable");
        data.remove("PortalCooldown");
        data.remove("UUID");
        spawnEgg.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)data));
        InventoryUtils.givePlayerStack((Player)player, spawnEgg);
        return 0;
    }

    @Nullable
    protected static Entity traceEntity(Player player) {
        Entity entity = null;
        return entity;
    }

    private static Map<UUID, GameProfile> accessiblePlayers(CommandSourceStack source) {
        HashMap<UUID, GameProfile> playerMap = new HashMap<UUID, GameProfile>();
        return playerMap;
    }

    private static int playerAccess(CommandSourceStack source, String target) throws CommandSyntaxException {
        GameProfileCache cache = source.getServer().getProfileCache();
        Map<UUID, GameProfile> playerMap = BCUtilCommands.accessiblePlayers(source);
        if (target == null) {
            source.sendSuccess(() -> Component.literal((String)"################## All Known Players ##################"), false);
            for (UUID uuid : playerMap.keySet()) {
                GameProfile profile = playerMap.get(uuid);
                boolean online = false;
                for (Player player : source.getServer().getPlayerList().getPlayers()) {
                    if (!player.getGameProfile().getId().equals(uuid)) continue;
                    online = true;
                    break;
                }
                MutableComponent message = Component.literal((String)((online ? String.valueOf(ChatFormatting.GREEN) + "[Online]: " : String.valueOf(ChatFormatting.GRAY) + "[Offline]: ") + profile.getName()));
                boolean offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + profile.getName()).getBytes(Charsets.UTF_8)).equals(uuid);
                if (offline) {
                    message.append((Component)Component.literal((String)" (Offline Account)").withStyle(ChatFormatting.RED));
                }
                MutableComponent messageHover = Component.literal((String)"Last Seen: \n").append((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "UUID: " + String.valueOf(uuid) + "\n"))).append((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + "-Click to access player.")));
                Style msgStyle = Style.EMPTY;
                msgStyle.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_util player_access " + String.valueOf(uuid)));
                msgStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)messageHover));
                message.setStyle(msgStyle);
                source.sendSuccess(() -> message, false);
            }
            return 0;
        }
        target = target.toLowerCase(Locale.ENGLISH);
        GameProfile profile = null;
        if (cache.get(target).isPresent()) {
            profile = (GameProfile)cache.get(target).get();
            target = profile.getId().toString();
        } else {
            try {
                profile = cache.get(UUID.fromString(target)).orElse(null);
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            if (profile == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Could not find the specified player name or uuid!")).create();
            }
        }
        ServerPlayer playerSender = source.getPlayerOrException();
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayer(profile.getId());
        if (targetPlayer == null) {
            File file = BCUtilCommands.getPlayerFile(source.getServer(), target);
        }
        if (playerSender == targetPlayer) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"This command only works on other players!")).create();
        }
        BCUtilCommands.openPlayerAccessUI(source.getServer(), playerSender, (Player)targetPlayer);
        return 0;
    }

    public static File getPlayerFile(MinecraftServer server, String uuid) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)Component.literal((String)"Could not find a data file for the specified player!")).create();
    }

    public static CompoundTag readPlayerCompound(File playerData) throws CommandSyntaxException {
        CompoundTag compoundTag;
        DataInputStream is = null;
        try {
            is = new DataInputStream(new GZIPInputStream(new FileInputStream(playerData)));
            CompoundTag compound = NbtIo.read((DataInput)is);
            IOUtils.closeQuietly((InputStream)is);
            compoundTag = compound;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new SimpleCommandExceptionType((Message)Component.literal((String)e.toString())).create();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return compoundTag;
    }

    public static void writePlayerCompound(File playerFile, CompoundTag playerCompound) throws IOException {
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(playerFile)));
            NbtIo.write((CompoundTag)playerCompound, (DataOutput)os);
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void openPlayerAccessUI(final MinecraftServer server, ServerPlayer player, final Player playerAccess) {
        BCoreNetwork.sendPlayerAccessUIUpdate(player, playerAccess);
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Player Access");
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                ContainerPlayerAccess access = new ContainerPlayerAccess(id, playerInventory, playerAccess, server);
                return access;
            }
        });
        NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.containerMenu));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDev1() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dev1").requires(cs -> cs.hasPermission(3))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            int radius = 90;
            BlockPos origin = player.blockPosition().offset(0, 88 - player.blockPosition().getY(), 0);
            BlockPos.betweenClosed((BlockPos)origin.offset(-radius, -20, -radius), (BlockPos)origin.offset(radius, 20, radius)).forEach(blockPos -> {
                if (Utils.getDistance(blockPos.getX(), blockPos.getZ(), origin.getX(), origin.getZ()) > (double)radius) {
                    return;
                }
                BlockState state = level.getBlockState(blockPos);
                if (state.is(BlockTags.LOGS) || state.is(BlockTags.LEAVES)) {
                    level.removeBlock(blockPos, false);
                }
            });
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDev2() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dev2").requires(cs -> cs.hasPermission(3))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            player.sendSystemMessage((Component)Component.literal((String)"Ligwewht!4dfdsf"));
            return 0;
        });
    }

    private static /* synthetic */ void lambda$functionNBT$39(Player player, String s) {
        ChatHelper.sendMessage(player, (Component)Component.literal((String)s).withStyle(ChatFormatting.GOLD));
    }
}

