/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;

public class FilterHostile
extends FilterBase {
    protected boolean whitelistHostile = true;

    public FilterHostile(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistHostile(boolean whitelistHostile) {
        boolean prev = this.whitelistHostile;
        this.whitelistHostile = whitelistHostile;
        this.getFilter().nodeModified(this);
        this.whitelistHostile = prev;
    }

    public boolean isWhitelistHostile() {
        return this.whitelistHostile;
    }

    @Override
    public boolean test(Entity entity) {
        if (entity instanceof Player) {
            return false;
        }
        boolean isHostile = entity instanceof Enemy;
        return isHostile == this.whitelistHostile;
    }

    @Override
    public FilterType getType() {
        return FilterType.HOSTILE;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putBoolean("include", this.whitelistHostile);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.whitelistHostile = nbt.getBoolean("include");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistHostile);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistHostile = input.readBoolean();
    }
}

