/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender) {
        switch (packet.getType()) {
            case 1: {
                this.handleContainerMessage(packet, sender);
                break;
            }
            case 3: {
                this.handleTileDataManager(packet, sender);
                break;
            }
            case 4: {
                ContributorHandler.handleSettingsFromClient(sender, packet);
                break;
            }
            case 5: {
                ContributorHandler.handleClientLink(sender);
            }
        }
    }

    private void handleContainerMessage(PacketCustom packet, ServerPlayer sender) {
        try {
            if (sender.containerMenu instanceof ContainerBCTile) {
                ((ContainerBCTile)sender.containerMenu).handleContainerMessage(packet, sender);
            }
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to read a packet sent from this client: " + String.valueOf(sender));
            e.printStackTrace();
        }
    }

    private void handleTileDataManager(PacketCustom packet, ServerPlayer sender) {
        try {
            if (sender.containerMenu instanceof ContainerBCTile) {
                ((ContainerBCTile)sender.containerMenu).handleTileDataPacket(packet, sender);
            }
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to read data manager a packet sent from this client: " + String.valueOf(sender));
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean verifyPlayerPermission(Player player, BlockPos pos) {
        if (!BCConfig.clientPermissionVerification) {
            return true;
        }
        BlockHitResult traceResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false);
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, InteractionHand.MAIN_HAND, pos, traceResult);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }
}

