/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.functions.TriPredicate;
import com.brandon3055.brandonscore.utils.DataUtils;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public static boolean hasStack(ItemStack stack, Container inventory) {
        if (stack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack s = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)s) || stack.getDamageValue() != s.getDamageValue() || s.getCount() < stack.getCount()) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeStack(ItemStack stack, Container inventory) {
        if (stack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack s = inventory.getItem(i);
            if (s.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)s) || stack.getDamageValue() != s.getDamageValue() || s.getCount() < stack.getCount()) continue;
            s.shrink(stack.getCount());
            inventory.setChanged();
            return true;
        }
        return false;
    }

    public static void handleHeldStackTransfer(int slot, Container inventory, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        if (!inventory.getItem(slot).isEmpty()) {
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, inventory.getItem(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.getItem(slot));
            }
            inventory.setItem(slot, ItemStack.EMPTY);
        } else {
            DataUtils.forEach(InteractionHand.values(), enumHand -> {
                ItemStack stack = player.getItemInHand(enumHand);
                if (!stack.isEmpty() && inventory.canPlaceItem(slot, stack) && inventory.getItem(slot).isEmpty()) {
                    inventory.setItem(slot, stack);
                    player.setItemInHand(enumHand, ItemStack.EMPTY);
                }
            });
        }
    }

    public static void handleHeldStackTransfer(int slot, IItemHandlerModifiable inventory, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        if (!inventory.getStackInSlot(slot).isEmpty()) {
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, inventory.getStackInSlot(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.getStackInSlot(slot));
            }
            inventory.setStackInSlot(slot, ItemStack.EMPTY);
        } else {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.getItemInHand(hand);
                if (stack.isEmpty() || !inventory.isItemValid(slot, stack)) continue;
                inventory.setStackInSlot(slot, stack);
                player.setItemInHand(hand, ItemStack.EMPTY);
                return;
            }
        }
    }

    public static void consumeHeldItem(Player player, ItemStack stack, InteractionHand hand) {
        stack.shrink(1);
        player.setItemInHand(hand, stack.getCount() > 0 ? stack.copy() : ItemStack.EMPTY);
    }

    public static void givePlayerStack(Player player, ItemStack stack) {
        if (player.level().isClientSide) {
            return;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            return;
        }
        player.getInventory().add(stack);
        if (stack.getCount() > 0) {
            InventoryUtils.dropItemNoDelay(stack, player.level(), Vector3.fromEntity((Entity)player));
        }
    }

    public static void dropItemNoDelay(ItemStack stack, Level world, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.setDeltaMovement(world.random.nextGaussian() * 0.05, world.random.nextGaussian() * 0.05 + (double)0.2f, world.random.nextGaussian() * 0.05);
        world.addFreshEntity((Entity)item);
        item.setNoPickUpDelay();
    }

    public static int findMatchingStack(IItemHandler itemHandler, TriPredicate<IItemHandler, ItemStack, Integer> predicate) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!predicate.test(itemHandler, itemHandler.getStackInSlot(i), i)) continue;
            return i;
        }
        return -1;
    }
}

