/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldEntitySaveData
extends SavedData {
    public static final String FILE_ID = "brandonscore_world_entity";
    private List<WorldEntity> entities = new ArrayList<WorldEntity>();
    private Runnable saveCallback;

    public void updateEntities(List<WorldEntity> entities) {
        this.entities.clear();
        if (entities != null) {
            this.entities.addAll(entities);
        }
    }

    public void setSaveCallback(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public List<WorldEntity> getEntities() {
        return this.entities;
    }

    public static WorldEntitySaveData load(CompoundTag nbt, HolderLookup.Provider provider) {
        WorldEntitySaveData data = new WorldEntitySaveData();
        ListTag list = nbt.getList("entities", 10);
        for (Tag inbt : list) {
            WorldEntity entity = WorldEntity.readWorldEntity((CompoundTag)inbt);
            if (entity == null) continue;
            data.entities.add(entity);
        }
        return data;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (WorldEntity entity : this.entities) {
            CompoundTag entityTag = new CompoundTag();
            entity.write(entityTag);
            list.add((Object)entityTag);
        }
        compound.put("entities", (Tag)list);
        return compound;
    }

    public void save(File fileIn, HolderLookup.Provider provider) {
        this.setDirty(true);
        this.saveCallback.run();
        super.save(fileIn, provider);
    }
}

