/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class Tank
extends FluidTank
implements IFluidHandlerCapacity,
IFluidHandlerMutable {
    public Tank(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            super.writeToNBT(lookupProvider, nbt);
        }
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt, String tag) {
        CompoundTag subTag = new CompoundTag();
        this.writeToNBT(lookupProvider, subTag);
        nbt.put(tag, (Tag)subTag);
        return nbt;
    }

    public FluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            if (nbt.contains("Empty")) {
                this.setFluid(null);
            }
            super.readFromNBT(lookupProvider, nbt);
        }
        this.readTankFromNBT(nbt);
        return this;
    }

    public FluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag data, String tag) {
        CompoundTag subTag = data.getCompound(tag);
        return this.readFromNBT(lookupProvider, subTag);
    }

    public void writeTankToNBT(CompoundTag nbt) {
        nbt.putInt("capacity", this.getCapacity());
    }

    public void readTankFromNBT(CompoundTag nbt) {
        if (nbt.contains("capacity")) {
            this.setCapacity(nbt.getInt("capacity"));
        }
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            this.setCapacity(capacity);
        }
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.getCapacity();
        }
        return 0;
    }
}

