/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.jetbrains.annotations.NotNull;

public class IngredientComponentStorageComposite<T, M>
implements IIngredientComponentStorage<T, M> {
    protected final IngredientComponent<T, M> ingredientComponent;
    protected final Collection<IIngredientComponentStorage<T, M>> storages;

    public IngredientComponentStorageComposite(IngredientComponent<T, M> ingredientComponent, Collection<IIngredientComponentStorage<T, M>> storages) {
        this.ingredientComponent = ingredientComponent;
        this.storages = storages;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.ingredientComponent;
    }

    public Iterator<T> iterator() {
        return Iterators.concat((Iterator)Iterators.transform(this.storages.iterator(), IIngredientComponentStorage::iterator));
    }

    public Iterator<T> iterator(@NotNull T prototype, M matchCondition) {
        return Iterators.concat((Iterator)Iterators.transform(this.storages.iterator(), i -> i.iterator(prototype, matchCondition)));
    }

    public long getMaxQuantity() {
        long sum = 0L;
        Iterator<IIngredientComponentStorage<T, M>> it = this.storages.iterator();
        while (it.hasNext() && sum < Long.MAX_VALUE) {
            try {
                sum = Math.addExact(sum, it.next().getMaxQuantity());
            }
            catch (ArithmeticException e) {
                sum = Long.MAX_VALUE;
            }
        }
        return sum;
    }

    public T insert(@NotNull T ingredient, boolean simulate) {
        IIngredientComponentStorage<T, M> storage;
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Iterator<IIngredientComponentStorage<T, M>> iterator = this.storages.iterator();
        while (iterator.hasNext() && !matcher.isEmpty(ingredient = (storage = iterator.next()).insert(ingredient, simulate))) {
        }
        return ingredient;
    }

    public T extract(@NotNull T prototype, M matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (IIngredientComponentStorage<T, M> storage : this.storages) {
            Object extracted = storage.extract(prototype, matchCondition, simulate);
            if (matcher.isEmpty(extracted)) continue;
            return (T)extracted;
        }
        return (T)matcher.getEmptyInstance();
    }

    public T extract(long maxQuantity, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (IIngredientComponentStorage<T, M> storage : this.storages) {
            Object extracted = storage.extract(maxQuantity, simulate);
            if (matcher.isEmpty(extracted)) continue;
            return (T)extracted;
        }
        return (T)matcher.getEmptyInstance();
    }
}

