/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.appliedsoul.common.me.strategy;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.buuz135.soulplied_energistics.applied.SoulAEKeyType;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class SoulStorageImportStrategy
implements StackImportStrategy {
    private final BlockCapabilityCache<ISoulHandler, Direction> cache;

    public SoulStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)SoulCapabilities.BLOCK, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled((AEKeyType)SoulAEKeyType.TYPE)) {
            return false;
        }
        ISoulHandler soulTile = (ISoulHandler)this.cache.getCapability();
        if (soulTile == null) {
            return false;
        }
        int remainingTransferAmount = context.getOperationsRemaining() * SoulAEKeyType.TYPE.getAmountPerOperation();
        int rawAmount = Math.min(remainingTransferAmount, soulTile.getSoulInTank(0));
        MEStorage inv = context.getInternalStorage().getInventory();
        int amount = (int)inv.insert((AEKey)SoulKey.INSTANCE, (long)rawAmount, Actionable.SIMULATE, context.getActionSource());
        if (amount > 0) {
            long leftover;
            int backFill;
            soulTile.drain(amount, ISoulHandler.Action.EXECUTE);
            long inserted = inv.insert((AEKey)SoulKey.INSTANCE, (long)amount, Actionable.MODULATE, context.getActionSource());
            if (inserted < (long)amount && (backFill = (int)Math.min(leftover = (long)amount - inserted, (long)(soulTile.getTankCapacity(0) - soulTile.getSoulInTank(0)))) > 0) {
                soulTile.fill(backFill, ISoulHandler.Action.EXECUTE);
            }
            long opsUsed = Math.max(1L, inserted / (long)SoulAEKeyType.TYPE.getAmountPerOperation());
            context.reduceOperationsRemaining(opsUsed);
        }
        return amount > 0;
    }
}

