/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.appliedsoul.data;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.ItemDefinition;
import appeng.items.storage.StorageTier;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.yxiao233.appliedsoul.common.item.SoulCellItem;
import net.yxiao233.appliedsoul.common.registry.SoulItems;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends VanillaRecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        StorageTier tier;
        for (ItemDefinition<SoulCellItem> cell : SoulItems.getCells()) {
            tier = ((SoulCellItem)cell.asItem()).getTier();
            String prefix = tier.namePrefix();
            Item component = (Item)tier.componentSupplier().get();
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, cell).requires(SoulItems.SOUL_CELL_HOUSING).requires((ItemLike)component).unlockedBy("has_soul_cell_housing", ModRecipeProvider.has(SoulItems.SOUL_CELL_HOUSING)).unlockedBy("has_cell_component_" + prefix, ModRecipeProvider.has((ItemLike)component)).save(output, String.valueOf(cell.id()) + "_storage");
            output.accept(cell.id().withSuffix("_disassembly"), (Recipe)new StorageCellDisassemblyRecipe(cell.asItem(), List.of(component.getDefaultInstance(), SoulItems.SOUL_CELL_HOUSING.stack())), null);
        }
        for (ItemDefinition<SoulCellItem> cell : SoulItems.getCells()) {
            tier = ((SoulCellItem)cell.asItem()).getTier();
            Item component = (Item)tier.componentSupplier().get();
            TitaniumShapedRecipeBuilder.shapedRecipe(cell).pattern("ABA").pattern("BEB").pattern("CDC").define(Character.valueOf('A'), (ItemLike)AEBlocks.QUARTZ_GLASS.asItem()).define(Character.valueOf('B'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('C'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('D'), (ItemLike)ModuleCore.PINK_SLIME_INGOT.get()).define(Character.valueOf('E'), (ItemLike)component).save(output, cell.id());
        }
        TitaniumShapedRecipeBuilder.shapedRecipe(SoulItems.SOUL_CELL_HOUSING).pattern("ABA").pattern("B B").pattern("CDC").define(Character.valueOf('A'), (ItemLike)AEBlocks.QUARTZ_GLASS.asItem()).define(Character.valueOf('B'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('C'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('D'), (ItemLike)ModuleCore.PINK_SLIME_INGOT.get()).save(output, SoulItems.SOUL_CELL_HOUSING.id());
    }
}

