/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.misc.ActuallyDamageTypes;
import de.ellpeck.actuallyadditions.mod.misc.MultiMessageDamageSource;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LensDeath
extends Lens {
    @Override
    public boolean invoke(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        List entities = tile.getWorldObject().getEntitiesOfClass(LivingEntity.class, new AABB((double)hitBlock.getX(), (double)hitBlock.getY(), (double)hitBlock.getZ(), (double)(hitBlock.getX() + 1), (double)(hitBlock.getY() + 1), (double)(hitBlock.getZ() + 1)));
        for (LivingEntity entity : entities) {
            int use = this.getUsePerEntity();
            if (tile.getEnergy() < use) continue;
            tile.extractEnergy(use);
            this.onAttacked(entity, tile);
        }
        return !hitState.isAir();
    }

    protected void onAttacked(LivingEntity entity, IAtomicReconstructor tile) {
        Holder.Reference type = entity.damageSources().damageTypes.getHolderOrThrow(ActuallyDamageTypes.ATOMIC_RECONSTRUCTOR);
        entity.hurt((DamageSource)new MultiMessageDamageSource((Holder<DamageType>)type, 5), 20.0f);
    }

    protected int getUsePerEntity() {
        return 350;
    }

    @Override
    public int getColor() {
        return 12377855;
    }

    @Override
    public int getDistance() {
        return 15;
    }
}

