/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.TeleporterBlockEntity;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.util.DimPos;

public class GemRedstoneTeleporterBlock
extends GemTeleporterBlock {
    public GemRedstoneTeleporterBlock(Gems gem, BlockBehaviour.Properties properties) {
        super(gem, properties, GemRedstoneTeleporterBlock::new);
    }

    @Override
    public MutableComponent getGemBlockName() {
        return Component.translatable((String)"block.silentgems.gem_redstone_teleporter", (Object[])new Object[]{this.gem.getDisplayName()});
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        boolean triggered = (Boolean)state.getValue((Property)TRIGGERED);
        if (hasSignal && !triggered) {
            this.tryTeleportNearbyEntities(level, pos);
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!hasSignal && triggered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void tryTeleportNearbyEntities(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TeleporterBlockEntity)) {
            return;
        }
        TeleporterBlockEntity teleporterBlockEntity = (TeleporterBlockEntity)blockEntity;
        DimPos destination = teleporterBlockEntity.getDestination();
        if (destination == null) {
            return;
        }
        int searchRadius = 5;
        List entitiesInArea = level.getEntitiesOfClass(Entity.class, new AABB(pos).inflate(5.0));
        boolean playSound = false;
        for (Entity entity : entitiesInArea) {
            if (!this.canTeleportEntity(level, entity, destination)) continue;
            this.teleportEntity(level, entity, destination);
            playSound = true;
        }
        if (playSound) {
            this.playTeleportSound(level, pos);
            this.playTeleportSound(level, destination);
        }
    }

    private boolean canTeleportEntity(Level level, Entity entity, DimPos destination) {
        return (entity.canChangeDimensions(level, destination.getPosLevel(level).orElse(level)) || destination.dimension().equals(entity.level().dimension())) && !entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED);
    }
}

