/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.teleporter.AbstractTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.TeleporterAnchorBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsBlockStateProvider
extends BlockStateProvider {
    public GemsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "silentgems", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation flowerPotCross = this.mcLoc("block/flower_pot_cross");
        for (Gems gem : Gems.values()) {
            this.simpleBlock((Block)gem.getOre());
            this.simpleBlock((Block)gem.getDeepslateOre());
            this.simpleBlock((Block)gem.getNetherOre());
            this.simpleBlock((Block)gem.getEndOre());
            this.simpleBlock(gem.getBlock());
            this.simpleBlock(gem.getBricks());
            this.simpleBlock(gem.getTiles());
            this.simpleBlock(gem.getSmallBricks());
            this.simpleBlock(gem.getPolishedStone());
            this.simpleBlock(gem.getSmoothStone());
            this.simpleBlock(gem.getChiseledStone());
            String glass = gem.getName() + "_glass";
            this.simpleBlock((Block)gem.getGlass(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(glass, this.modLoc("block/" + glass))).renderType("translucent"));
            for (GemLampBlock.State state : GemLampBlock.State.values()) {
                this.simpleBlock(gem.getLamp(state), "block/" + gem.getName() + "_lamp" + (state.lit() ? "_on" : ""));
            }
            String glowroseName = gem.getName() + "_glowrose";
            this.simpleBlock((Block)gem.getGlowrose(), (ModelFile)((BlockModelBuilder)this.models().cross(glowroseName, this.modLoc("block/" + glowroseName))).renderType("cutout"));
            this.simpleBlock((Block)gem.getPottedGlowrose(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.fromBlock((Block)gem.getPottedGlowrose()).getPath(), flowerPotCross)).texture("plant", this.modLoc("block/" + glowroseName))).renderType("cutout"));
            this.teleporterBlock(gem, false);
            this.teleporterBlock(gem, true);
        }
        this.teleporterAnchor((TeleporterAnchorBlock)((Object)GemsBlocks.TELEPORTER_ANCHOR.get()));
        this.simpleBlock((Block)GemsBlocks.CHAOS_ESSENCE_BLOCK.get());
        this.simpleBlock((Block)GemsBlocks.CHAOS_ORE.get());
        this.simpleBlock((Block)GemsBlocks.DEEPSLATE_CHAOS_ORE.get());
        this.simpleBlock((Block)GemsBlocks.SILVER_BLOCK.get());
        this.simpleBlock((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get());
        this.simpleBlock((Block)GemsBlocks.SILVER_ORE.get());
    }

    private void simpleBlock(IBlockProvider block) {
        this.simpleBlock(block.asBlock());
    }

    private void simpleBlock(IBlockProvider block, String texture) {
        this.simpleBlock(block.asBlock(), texture);
    }

    private void simpleBlock(Block block, String texture) {
        String name = NameUtils.fromBlock((Block)block).getPath();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(name, this.modLoc(texture)));
    }

    private void teleporterBlock(Gems gem, boolean redstone) {
        GemTeleporterBlock teleporterBlock = redstone ? (GemTeleporterBlock)gem.getRedstoneTeleporter().get() : (GemTeleporterBlock)gem.getTeleporter().get();
        ResourceLocation frameTexture = this.modLoc("block/" + (redstone ? "redstone_teleporter_frame" : "teleporter_frame"));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.fromBlock((Block)teleporterBlock).getPath(), this.modLoc("block/teleporter"))).texture("gem", this.modLoc("block/" + gem.getName() + "_block"))).texture("frame", frameTexture);
        this.getVariantBuilder((Block)teleporterBlock).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)AbstractTeleporterBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)facing.getOpposite().toYRot()).build();
        });
    }

    private void teleporterAnchor(TeleporterAnchorBlock teleporterAnchorBlock) {
        this.getVariantBuilder((Block)teleporterAnchorBlock).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)AbstractTeleporterBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/teleporter_anchor"))).rotationY((int)facing.getOpposite().toYRot()).build();
        });
    }
}

