/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsItemModelProvider
extends ItemModelProvider {
    public GemsItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "silentgems", existingFileHelper);
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated"));
        GemsBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block.asItem() != Items.AIR).forEach(this::blockBuilder);
        GemsItems.getSimpleModelItems().forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        for (Gems gem : Gems.values()) {
            this.builder((ItemLike)gem.getItem(), (ModelFile)itemGenerated);
        }
    }

    private void blockBuilder(IBlockProvider block) {
        this.blockBuilder(block.asBlock());
    }

    private void blockBuilder(Block block) {
        String name = NameUtils.fromBlock((Block)block).getPath();
        if (!this.blockBuilderExceptions(block, name)) {
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private boolean blockBuilderExceptions(Block block, String name) {
        if (block instanceof GlowroseBlock) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).texture("layer0", this.modLoc("block/" + name));
            return true;
        }
        return false;
    }

    private void builder(ItemLike item, ModelFile parent) {
        String name = NameUtils.fromItem((ItemLike)item).getPath();
        this.builder(item, parent, "item/" + name);
    }

    private void builder(ItemLike item, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).getPath())).parent(parent)).texture("layer0", this.modLoc(texture));
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, DeferredItem iro) {
        this.builder((ItemLike)iro.get(), itemGenerated);
    }
}

