/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class StackData
extends AbstractDataStore<ItemStack> {
    public StackData() {
        super(ItemStack.EMPTY);
    }

    public StackData(ItemStack defaultValue) {
        super(defaultValue);
    }

    @Override
    public ItemStack set(ItemStack value) {
        if (!ItemStack.matches((ItemStack)value, (ItemStack)((ItemStack)this.value)) && this.validator.test(value)) {
            this.value = value.copy();
            this.markDirty();
        }
        return (ItemStack)this.value;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)((ItemStack)this.value));
    }

    @Override
    public void fromBytes(RegistryFriendlyByteBuf buf) {
        this.value = this.validValue((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf), (ItemStack)this.value);
    }

    @Override
    public Tag toTag(HolderLookup.Provider provider) {
        return ((ItemStack)this.value).saveOptional(provider);
    }

    @Override
    public void fromTag(HolderLookup.Provider provider, Tag tag) {
        this.value = this.validValue(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)tag)), (ItemStack)this.value);
    }

    @Override
    public boolean isSameValue(ItemStack newValue) {
        return ItemStack.matches((ItemStack)((ItemStack)this.value), (ItemStack)newValue);
    }
}

