/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos;

import com.mojang.brigadier.CommandDispatcher;
import com.sts15.fargos.block.BlocksInit;
import com.sts15.fargos.block.entity.BlockEntitiesInit;
import com.sts15.fargos.block.entity.renderer.PedestalBlockEntityRenderer;
import com.sts15.fargos.client.command.TalismanCommand;
import com.sts15.fargos.client.command.TalismanScreenCommand;
import com.sts15.fargos.client.elytra.MyElytraLayer;
import com.sts15.fargos.client.hud.FireUIRenderer;
import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.init.CreativeTabRegistry;
import com.sts15.fargos.init.SoundRegistry;
import com.sts15.fargos.items.ItemInit;
import com.sts15.fargos.loot.LootRegistry;
import com.sts15.fargos.network.NetworkHandler;
import java.util.Objects;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="fargostalismans")
public class Fargos {
    public static final String MODID = "fargostalismans";

    public Fargos(IEventBus modEventBus, ModContainer modContainer) {
        Config.register(modContainer);
        Objects.requireNonNull(modContainer.getEventBus()).addListener(this::registerPayloads);
        ItemInit.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        BlocksInit.register(modEventBus);
        BlockEntitiesInit.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        EffectsInit.register(modEventBus);
        LootRegistry.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        NetworkHandler.registerPackets(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        TalismanCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterClientCommandsEvent event) {
        TalismanScreenCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @EventBusSubscriber(modid="fargostalismans", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            NeoForge.EVENT_BUS.register(FireUIRenderer.class);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.AddLayers event) {
            PlayerRenderer defaultRenderer = (PlayerRenderer)event.getSkin(PlayerSkin.Model.WIDE);
            PlayerRenderer slimRenderer = (PlayerRenderer)event.getSkin(PlayerSkin.Model.SLIM);
            if (defaultRenderer != null) {
                defaultRenderer.addLayer((RenderLayer)new MyElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)defaultRenderer));
            }
            if (slimRenderer != null) {
                slimRenderer.addLayer((RenderLayer)new MyElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)slimRenderer));
            }
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(BlockEntitiesInit.PEDESTAL_BE.get(), PedestalBlockEntityRenderer::new);
        }
    }
}

