/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Ankh_Shield_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AnkhShieldItem
extends TalismanItem
implements ICurioItem,
Ankh_Shield_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "ankh_shield";

    public AnkhShieldItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.ankh_shield").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!AnkhShieldItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for ankh_shield");
        }
        return isEnabled;
    }

    private static void negateNegativeEffects(Player player) {
        List<MobEffectInstance> targetedEffects = player.getActiveEffects().stream().filter(effectInstance -> {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            return effect.equals(MobEffects.POISON.value()) || effect.equals(MobEffects.DARKNESS.value()) || effect.equals(MobEffects.MOVEMENT_SLOWDOWN.value());
        }).toList();
        targetedEffects.forEach(effect -> player.removeEffect(effect.getEffect()));
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Ankh_Shield_Provider, (LivingEntity)player2).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player2, AnkhShieldItem.charmName)) {
                    return;
                }
                AnkhShieldItem.negateNegativeEffects((Player)player2);
            }
        }
    }
}

