/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Bee_Cloak_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class BeeCloakItem
extends TalismanItem
implements Bee_Cloak_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "bee_cloak";

    public BeeCloakItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.bee_cloak").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!BeeCloakItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            LOGGER.error("Error checking config status for bee_cloak", (Throwable)e);
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Bee)) {
                return;
            }
            Bee bee = (Bee)livingEntity;
            LivingEntity newTarget = event.getNewAboutToBeSetTarget();
            if (!(newTarget instanceof Player)) {
                return;
            }
            Player player = (Player)newTarget;
            boolean hasBeeCloak = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Bee_Cloak_Provider, (LivingEntity)player).isPresent();
            if (hasBeeCloak && BeeCloakItem.checkConfigEnabledStatus()) {
                if (!TalismanUtil.isTalismanEnabled(player, BeeCloakItem.charmName)) {
                    return;
                }
                event.setCanceled(true);
                bee.setTarget(null);
                bee.stopBeingAngry();
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasBeeCloak = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Bee_Cloak_Provider, (LivingEntity)player2).isPresent();
            if (!hasBeeCloak || !BeeCloakItem.checkConfigEnabledStatus()) {
                return;
            }
            if (!TalismanUtil.isTalismanEnabled(player2, BeeCloakItem.charmName)) {
                return;
            }
            BlockPos playerPos = player2.blockPosition();
            Level level = player2.level();
            int radius = 3;
            boolean nearBeeNest = BlockPos.betweenClosedStream((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius)).anyMatch(pos -> {
                BlockState state = level.getBlockState(pos);
                return state.is(Blocks.BEE_NEST) || state.is(Blocks.BEEHIVE);
            });
            if (nearBeeNest && level.getGameTime() % 40L == 0L && player2.getFoodData().needsFood()) {
                player2.getFoodData().eat(1, 0.5f);
                level.playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.BEE_LOOP, player2.getSoundSource(), 0.3f, 0.8f);
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (player2.getRandom().nextDouble() - 0.5) * 0.5;
                    double offsetZ = (player2.getRandom().nextDouble() - 0.5) * 0.5;
                    double posY = player2.getY() + 1.0;
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.FALLING_HONEY, player2.getX() + offsetX, posY, player2.getZ() + offsetZ, 1, 0.0, -0.1, 0.0, 0.02);
                }
            }
        }
    }
}

