/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Frozen_Shield_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class FrozenShieldItem
extends TalismanItem
implements Frozen_Shield_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "frozen_shield";
    private static final int RESISTANCE_AMPLIFIER = 0;
    private static final int RESISTANCE_DURATION = 40;

    public FrozenShieldItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.frozen_shield").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!FrozenShieldItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for frozen_shield", (Throwable)e);
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasFrozenShieldEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Frozen_Shield_Provider, (LivingEntity)player2).isPresent();
            if (!hasFrozenShieldEquipped || !FrozenShieldItem.checkConfigEnabledStatus()) {
                Events.removeFrozenShieldResistance((Player)player2);
                return;
            }
            if (!TalismanUtil.isTalismanEnabled(player2, FrozenShieldItem.charmName)) {
                return;
            }
            float halfHealth = player2.getMaxHealth() / 2.0f;
            if (player2.getHealth() < halfHealth) {
                Events.applyFrozenShieldResistance((Player)player2);
            } else {
                Events.removeFrozenShieldResistance((Player)player2);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            LivingEntity entity = event.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity;
            DamageSource source = event.getSource();
            ResourceKey fallDamageType = DamageTypes.FREEZE;
            if (source.is(fallDamageType)) {
                boolean hasFrozenShieldEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Frozen_Shield_Provider, (LivingEntity)player).isPresent();
                if (!TalismanUtil.isTalismanEnabled(player, FrozenShieldItem.charmName)) {
                    return;
                }
                if (hasFrozenShieldEquipped) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
            }
        }

        private static void applyFrozenShieldResistance(Player player) {
            MobEffectInstance resistance = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 0, false, false);
            MobEffectInstance currentEffect = player.getEffect(MobEffects.DAMAGE_RESISTANCE);
            if (currentEffect == null || currentEffect.getAmplifier() < 0 || currentEffect.getDuration() < 10) {
                player.addEffect(resistance);
            }
        }

        private static void removeFrozenShieldResistance(Player player) {
            MobEffectInstance currentEffect = player.getEffect(MobEffects.DAMAGE_RESISTANCE);
            if (currentEffect != null) {
                boolean isOurEffect;
                boolean bl = isOurEffect = currentEffect.getAmplifier() == 0 && currentEffect.getDuration() <= 40;
                if (isOurEffect) {
                    player.removeEffect(MobEffects.DAMAGE_RESISTANCE);
                }
            }
        }
    }
}

