/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Mechanical_Cart_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MechanicalCartItem
extends TalismanItem
implements ICurioItem,
Mechanical_Cart_Provider {
    public static final String charmName = "mechanical_cart";

    public MechanicalCartItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.mechanical_cart").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!MechanicalCartItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            return true;
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Mechanical_Cart_Provider, (LivingEntity)player2).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player2, MechanicalCartItem.charmName);
            if (!equipped || !enabled) {
                return;
            }
            Entity entity = player2.getVehicle();
            if (entity instanceof AbstractMinecart) {
                AbstractMinecart minecart = (AbstractMinecart)entity;
                Vec3 motion = minecart.getDeltaMovement();
                double speedBoost = 10.0;
                double newX = motion.x * (1.0 + speedBoost);
                double newZ = motion.z * (1.0 + speedBoost);
                minecart.setDeltaMovement(newX, motion.y, newZ);
                minecart.hasImpulse = true;
            }
        }
    }
}

