/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Copper_Talisman
extends TalismanItem {
    private static final String talismanName = "copper_talisman";

    public Copper_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.copper_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Copper_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            ServerPlayer player;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && ((player = (ServerPlayer)player2).hasEffect(EffectsInit.COPPER_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Copper_Talisman, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Copper_Talisman.talismanName)) {
                    return;
                }
                Events.attractItems((Player)player);
            }
        }

        private static void attractItems(Player player) {
            Level level = player.level();
            AABB area = player.getBoundingBox().inflate((double)Config.COPPER_TALISMAN_AREA.getAsInt());
            AABB playerArea = player.getBoundingBox().inflate((double)Config.COPPER_TALISMAN_PLAYER_AREA.getAsInt());
            List items = level.getEntitiesOfClass(ItemEntity.class, area);
            List<ServerPlayer> nearbyPlayers = level.getEntitiesOfClass(ServerPlayer.class, playerArea).stream().filter(p -> CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Copper_Talisman, (LivingEntity)p).isPresent()).toList();
            for (ItemEntity item : items) {
                double zDir;
                double yDir;
                if (item.hasPickUpDelay() || !item.isAlive()) continue;
                ServerPlayer closestPlayer = null;
                double closestDistance = Double.MAX_VALUE;
                for (ServerPlayer p2 : nearbyPlayers) {
                    double distance = p2.distanceToSqr((Entity)item);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPlayer = p2;
                }
                if (closestPlayer == null || closestPlayer != player) continue;
                double speed = Config.COPPER_TALISMAN_SPEED.getAsDouble();
                double xDir = player.getX() - item.getX();
                double distance = Math.sqrt(xDir * xDir + (yDir = player.getEyeY() - item.getY()) * yDir + (zDir = player.getZ() - item.getZ()) * zDir);
                if (distance < Config.COPPER_TALISMAN_DISTANCE_TO_PICKUP.getAsDouble()) {
                    item.teleportTo(player.getX(), player.getY(), player.getZ());
                    continue;
                }
                item.setDeltaMovement(item.getDeltaMovement().add(xDir / distance * speed, yDir / distance * speed, zDir / distance * speed));
            }
        }
    }
}

