/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Iron_Golem_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Iron_Golem_Talisman
extends TalismanItem
implements Iron_Golem_Talisman_Provider {
    private static final String talismanName = "iron_golem_talisman";
    private static final ResourceLocation HEALTH_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"iron_golem_health_boost");
    private static final ResourceLocation HEALTH_DATA_KEY = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"iron_golem_health");

    public Iron_Golem_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.iron_golem_talisman", (Object[])new Object[]{(int)(Config.IRON_GOLEM_TALISMAN_HEALTH_BOOST_MULTIPLIER.getAsDouble() * 100.0)}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Iron_Golem_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    public static void resetHealth(Player player) {
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttribute != null && healthAttribute.hasModifier(HEALTH_BOOST_ID)) {
            healthAttribute.removeModifier(HEALTH_BOOST_ID);
        }
    }

    public static void increaseHealth(Player player) {
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttribute != null && !healthAttribute.hasModifier(HEALTH_BOOST_ID)) {
            AttributeModifier modifier = new AttributeModifier(HEALTH_BOOST_ID, Config.IRON_GOLEM_TALISMAN_HEALTH_BOOST_MULTIPLIER.getAsDouble(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            healthAttribute.addTransientModifier(modifier);
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        Iron_Golem_Talisman.increaseHealth(entity);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        boolean hasIronGolemTalismanEffect = entity.hasEffect(EffectsInit.IRON_GOLEM_TALISMAN_EFFECT);
        if (!hasIronGolemTalismanEffect) {
            Iron_Golem_Talisman.resetHealth(entity);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (++tickCounter < 10) {
                return;
            }
            tickCounter = 0;
            boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Iron_Golem_Talisman_Provider, (LivingEntity)player2).isPresent();
            if (hasEquippedCurio) {
                if (TalismanUtil.isTalismanEnabled(player2, Iron_Golem_Talisman.talismanName)) {
                    Iron_Golem_Talisman.increaseHealth((Player)player2);
                } else {
                    Iron_Golem_Talisman.resetHealth((Player)player2);
                }
            } else {
                Iron_Golem_Talisman.resetHealth((Player)player2);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getPersistentData().putFloat(HEALTH_DATA_KEY.toString(), player2.getHealth());
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.getPersistentData().contains(HEALTH_DATA_KEY.toString())) {
                boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Iron_Golem_Talisman_Provider, (LivingEntity)player2).isPresent();
                boolean hasEffect = player2.hasEffect(EffectsInit.IRON_GOLEM_TALISMAN_EFFECT);
                if (hasEffect || hasEquippedCurio) {
                    Iron_Golem_Talisman.increaseHealth((Player)player2);
                    player2.setHealth(player2.getPersistentData().getFloat(HEALTH_DATA_KEY.toString()));
                }
                player2.getPersistentData().remove(HEALTH_DATA_KEY.toString());
            }
        }
    }
}

