/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Librarian_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Redirect(method={"createExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private static void redirectAwardExperience(ServerLevel level, Vec3 position, int amount, ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        ServerPlayer player = (ServerPlayer)level.getNearestPlayer(position.x(), position.y(), position.z(), 5.0, false);
        if (player != null && AbstractFurnaceBlockEntityMixin.hasLibrarianTalisman(player)) {
            int modifiedAmount = Math.round((float)amount * 1.5f);
            ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)modifiedAmount);
        } else {
            ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)amount);
        }
    }

    private static boolean hasLibrarianTalisman(ServerPlayer player) {
        if (!TalismanUtil.isTalismanEnabled(player, "librarian_talisman")) {
            return false;
        }
        return player.hasEffect(EffectsInit.LIBRARIAN_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Librarian_Talisman_Provider, (LivingEntity)player).isPresent();
    }
}

