/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Librarian_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={Villager.class})
public abstract class VillagerMixin {
    @Shadow
    private Player lastTradedPlayer;

    @ModifyArg(method={"rewardTradeXp"}, at=@At(value="NEW", target="Lnet/minecraft/world/entity/ExperienceOrb;(Lnet/minecraft/world/level/Level;DDDI)V"), index=4)
    private int ModifyRewardTradeXp(int xp) {
        Player player = this.lastTradedPlayer;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!this.lastTradedPlayer.level().isClientSide() && this.hasLibrarianTalisman(player2)) {
                xp = Math.round((float)xp * 1.5f);
            }
        }
        return xp;
    }

    private boolean hasLibrarianTalisman(ServerPlayer player) {
        if (!TalismanUtil.isTalismanEnabled(player, "librarian_talisman")) {
            return false;
        }
        return player.hasEffect(EffectsInit.LIBRARIAN_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Librarian_Talisman_Provider, (LivingEntity)player).isPresent();
    }
}

