/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.network.packet;

import com.sts15.fargos.config.PlayerDataHandler;
import com.sts15.fargos.network.NetworkHandler;
import com.sts15.fargos.network.TalismanType;
import com.sts15.fargos.screen.TalismanToggleScreen;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TalismanStatePacket
implements CustomPacketPayload {
    private final Map<Integer, Boolean> talismanStates;
    public static final CustomPacketPayload.Type<TalismanStatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"talisman_state"));
    public static final StreamCodec<FriendlyByteBuf, TalismanStatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)ByteBufCodecs.BOOL), TalismanStatePacket::getTalismanStates, TalismanStatePacket::new);

    public TalismanStatePacket(Map<Integer, Boolean> talismanStates) {
        this.talismanStates = talismanStates;
    }

    public TalismanStatePacket(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        this.talismanStates = new HashMap<Integer, Boolean>();
        for (int i = 0; i < size; ++i) {
            int index = buf.readVarInt();
            boolean enabled = buf.readBoolean();
            this.talismanStates.put(index, enabled);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TalismanStatePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (packet.talismanStates.isEmpty()) {
                HashMap<Integer, Boolean> talismanStates = new HashMap<Integer, Boolean>();
                for (TalismanType talismanType : TalismanType.values()) {
                    boolean isEnabled = PlayerDataHandler.getTalismanState(serverPlayer, talismanType.name());
                    talismanStates.put(talismanType.getIndex(), isEnabled);
                }
                NetworkHandler.sendTalismanStateToClient(serverPlayer, talismanStates);
            }
        } else if (context.player().level().isClientSide()) {
            Minecraft.getInstance().execute(() -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    packet.talismanStates.forEach((index, isEnabled) -> {
                        TalismanType talismanType = TalismanType.byIndex(index);
                        PlayerDataHandler.setTalismanState(player, talismanType.name(), (boolean)isEnabled);
                    });
                    Screen patt0$temp = Minecraft.getInstance().screen;
                    if (patt0$temp instanceof TalismanToggleScreen) {
                        TalismanToggleScreen screen = (TalismanToggleScreen)patt0$temp;
                        screen.setTalismanStates(packet.getTalismanStates());
                    }
                }
            });
        }
    }

    public Map<Integer, Boolean> getTalismanStates() {
        return this.talismanStates;
    }
}

