/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;

public class WardenAttackTracker {
    private static final Map<Warden, Set<UUID>> attackMap = new WeakHashMap<Warden, Set<UUID>>();

    public static void markAttacked(Warden warden, Player player) {
        attackMap.computeIfAbsent(warden, w -> new HashSet()).add(player.getUUID());
    }

    public static boolean hasAttacked(Warden warden, Player player) {
        return attackMap.getOrDefault(warden, Collections.emptySet()).contains(player.getUUID());
    }

    public static void clear(Warden warden) {
        attackMap.remove(warden);
    }
}

