/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.pipez.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ClearComponentsRecipe
extends CustomRecipe {
    private final Ingredient ingredient;
    private final List<ResourceLocation> components;

    public ClearComponentsRecipe(Ingredient ingredient, List<ResourceLocation> components) {
        super(CraftingBookCategory.MISC);
        this.ingredient = ingredient;
        this.components = components;
    }

    @Nullable
    public ItemStack getIngredient(CraftingInput inv) {
        ItemStack found = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (this.ingredient.test(stackInSlot)) {
                if (found != null) {
                    return null;
                }
                found = stackInSlot;
                continue;
            }
            if (stackInSlot.isEmpty()) continue;
            return null;
        }
        return found;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return this.getIngredient(inv) != null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack ingredient = this.getIngredient(inv);
        if (ingredient == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ingredient.copy();
        for (Map.Entry e : stack.getComponentsPatch().entrySet()) {
            ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)e.getKey()));
            if (key == null || !this.components.contains(key)) continue;
            stack.remove((DataComponentType)e.getKey());
        }
        stack.setCount(1);
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CLEAR_NBT.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public static class Serializer
    implements RecipeSerializer<ClearComponentsRecipe> {
        private static final MapCodec<ClearComponentsRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(recipe -> recipe.ingredient), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("components").forGetter(recipe -> recipe.components)).apply((Applicative)builder, ClearComponentsRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ClearComponentsRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ResourceLocation.STREAM_CODEC), r -> r.components, ClearComponentsRecipe::new);

        public MapCodec<ClearComponentsRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ClearComponentsRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

