/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_enchanting.ApothEnchConfig;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryScreen;
import dev.shadowsoffire.apothic_enchanting.payloads.CluePayload;
import dev.shadowsoffire.apothic_enchanting.payloads.StatsPayload;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentScreen;
import dev.shadowsoffire.apothic_enchanting.util.FakeLevelReader;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.util.DrawsOnLeft;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.particle.FlyTowardsPositionParticle;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="apothic_enchanting", value={Dist.CLIENT})
public class ApothEnchClient {
    private static final BlockHitResult MISS = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.NORTH, (BlockPos)BlockPos.ZERO);

    @SubscribeEvent
    public static void client(FMLClientSetupEvent e) {
        NeoForge.EVENT_BUS.register((Object)new ForgeBusEvents());
    }

    @SubscribeEvent
    public static void screens(RegisterMenuScreensEvent e) {
        e.register(Ench.Menus.ENCHANTING_TABLE, ApothEnchantmentScreen::new);
        e.register(Ench.Menus.LIBRARY, EnchLibraryScreen::new);
    }

    @SubscribeEvent
    public static void particleFactories(RegisterParticleProvidersEvent e) {
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_FIRE, FlyTowardsPositionParticle.EnchantProvider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_WATER, FlyTowardsPositionParticle.EnchantProvider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_SCULK, FlyTowardsPositionParticle.EnchantProvider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_END, FlyTowardsPositionParticle.EnchantProvider::new);
    }

    public static void handleCluePayload(CluePayload msg) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ApothEnchantmentScreen) {
            ApothEnchantmentScreen es = (ApothEnchantmentScreen)screen;
            es.acceptClues(msg.slot(), msg.clues(), msg.all());
        }
    }

    public static void handleStatsPayload(StatsPayload msg) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ApothEnchantmentScreen) {
            ApothEnchantmentScreen es = (ApothEnchantmentScreen)screen;
            es.getMenu().setStats(msg.stats());
        }
    }

    @Nullable
    public static <T> Registry<T> findClientRegistry(ResourceKey<? extends Registry<T>> registryKey) {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        if (listener == null) {
            return null;
        }
        return listener.registryAccess().registry(registryKey).orElse(null);
    }

    private static Component boolComp(String key, boolean flag) {
        return Component.translatable((String)(key + (flag ? "" : ".not"))).withStyle(Style.EMPTY.withColor(flag ? 0x108810 : 0xAA1616));
    }

    public static class ForgeBusEvents {
        @SubscribeEvent
        public void tooltips(ItemTooltipEvent e) {
            ItemStack stack;
            ItemEnchantments enchMap;
            Item i = e.getItemStack().getItem();
            List tooltip = e.getToolTip();
            if (i == Ench.Items.PRISMATIC_WEB.value()) {
                tooltip.add(TooltipUtil.lang("info", "prismatic_cobweb", new Object[0]).withStyle(ChatFormatting.GRAY));
            } else if (i instanceof BlockItem) {
                Block block = ((BlockItem)i).getBlock();
                BlockState state = block.defaultBlockState();
                Level level = e.getContext().level();
                if (level != null && Minecraft.getInstance().player != null) {
                    BlockPlaceContext ctx = new BlockPlaceContext(level, (Player)Minecraft.getInstance().player, InteractionHand.MAIN_HAND, e.getItemStack(), MISS);
                    try {
                        state = block.getStateForPlacement(ctx);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (state == null) {
                    state = block.defaultBlockState();
                }
                try {
                    Object reader = level == null ? new FakeLevelReader(state) : level;
                    TooltipUtil.appendBlockStats((LevelReader)reader, state, BlockPos.ZERO, tooltip::add);
                }
                catch (NullPointerException reader) {}
            } else if (i == Items.ENCHANTED_BOOK && (enchMap = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)(stack = e.getItemStack()))).size() == 1) {
                EnchantmentInfo info;
                String key;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)enchMap.entrySet().iterator().next();
                Holder ench = (Holder)entry.getKey();
                int level = entry.getIntValue();
                if (!ModList.get().isLoaded("enchdesc") && I18n.exists((String)(key = ench.getKey().location().toLanguageKey("enchantment") + ".desc"))) {
                    tooltip.add(Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY));
                }
                if (ApothEnchConfig.showEnchantedBookMetadata) {
                    info = ApothicEnchanting.getEnchInfo((Holder<Enchantment>)ench);
                    Object[] args = new Object[]{ApothEnchClient.boolComp("info.apothic_enchanting.discoverable", ench.is(EnchantmentTags.IN_ENCHANTING_TABLE)), ApothEnchClient.boolComp("info.apothic_enchanting.lootable", ench.is(EnchantmentTags.ON_RANDOM_LOOT)), ApothEnchClient.boolComp("info.apothic_enchanting.tradeable", ench.is(EnchantmentTags.TRADEABLE)), ApothEnchClient.boolComp("info.apothic_enchanting.treasure", ench.is(EnchantmentTags.TREASURE))};
                    if (e.getFlags().isAdvanced()) {
                        tooltip.add(Component.translatable((String)"%s \u2507 %s \u2507 %s \u2507 %s", (Object[])new Object[]{args[0], args[1], args[2], args[3]}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(Component.translatable((String)"info.apothic_enchanting.book_range", (Object[])new Object[]{info.getMinPower(level), info.getMaxPower(level)}).withStyle(ChatFormatting.GREEN));
                    } else {
                        tooltip.add(Component.translatable((String)"%s \u2507 %s", (Object[])new Object[]{args[2], args[3]}).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
                if ((info = ApothicEnchanting.getEnchInfo((Holder<Enchantment>)ench)).levelCap() != -1) {
                    Iterator it = tooltip.iterator();
                    Component toReplace = null;
                    while (it.hasNext()) {
                        Component comp = (Component)it.next();
                        if (!comp.contains(((Enchantment)ench.value()).description())) continue;
                        toReplace = comp;
                        break;
                    }
                    if (toReplace != null) {
                        MutableComponent newComp = toReplace.copy();
                        MutableComponent limit = Component.translatable((String)"info.apothic_enchanting.limit", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + info.levelCap()))}).withStyle(ChatFormatting.DARK_GRAY);
                        newComp.append(CommonComponents.SPACE).append((Component)limit);
                        tooltip.set(tooltip.indexOf(toReplace), newComp);
                    }
                }
            }
        }

        @SubscribeEvent
        public void drawAnvilCostBlob(ScreenEvent.Render.Post e) {
            Screen screen = e.getScreen();
            if (screen instanceof AnvilScreen) {
                AnvilScreen anv = (AnvilScreen)screen;
                int level = ((AnvilMenu)anv.getMenu()).getCost();
                if (level <= 0 || !((AnvilMenu)anv.getMenu()).getSlot(((AnvilMenu)anv.getMenu()).getResultSlot()).hasItem() || level == Integer.MAX_VALUE) {
                    return;
                }
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                list.add(TooltipUtil.lang("info", "anvil_at", level).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}));
                int expCost = EnchantmentUtils.getTotalExperienceForLevel((int)level);
                list.add(TooltipUtil.lang("info", "anvil_xp_cost", Component.literal((String)("" + expCost)).withStyle(ChatFormatting.GREEN), Component.literal((String)("" + level)).withStyle(ChatFormatting.GREEN)));
                DrawsOnLeft.draw((AbstractContainerScreen)anv, (GuiGraphics)e.getGuiGraphics(), list, (int)(anv.getGuiTop() + 28));
            }
        }
    }
}

