/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.library;

import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryContainer;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import dev.shadowsoffire.placebo.menu.SimplerMenuProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnchLibraryBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final Component NAME = TooltipUtil.lang("menu", "library", new Object[0]);
    protected final BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile> tileSupplier;
    protected final int maxLevel;

    public EnchLibraryBlock(BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile> tileSupplier, int maxLevel) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(5.0f, 1200.0f));
        this.tileSupplier = tileSupplier;
        this.maxLevel = maxLevel;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return MenuUtil.openGui((Player)player, (BlockPos)pos, EnchLibraryContainer::new);
    }

    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        return new SimplerMenuProvider(world, pos, EnchLibraryContainer::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_196258_1_.getHorizontalDirection().getOpposite());
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return this.tileSupplier.create(pPos, pState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack s = new ItemStack((ItemLike)this);
        BlockEntity te = level.getBlockEntity(pos);
        if (te != null) {
            te.saveToItem(s, (HolderLookup.Provider)level.registryAccess());
        }
        return s;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        BlockEntity be = level.getBlockEntity(pos);
        if (!data.isEmpty() && be instanceof EnchLibraryTile) {
            EnchLibraryTile lib = (EnchLibraryTile)be;
            data.loadInto((BlockEntity)lib, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder ctx) {
        ItemStack s = new ItemStack((ItemLike)this);
        BlockEntity te = (BlockEntity)ctx.getParameter(LootContextParams.BLOCK_ENTITY);
        if (te != null) {
            te.saveToItem(s, (HolderLookup.Provider)ctx.getLevel().registryAccess());
        }
        return Arrays.asList(s);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        int points;
        list.add((Component)Component.translatable((String)"tooltip.enchlib.capacity", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + this.maxLevel))}).withStyle(ChatFormatting.GOLD));
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!data.isEmpty() && data.contains("points") && (points = data.getUnsafe().getCompound("points").size()) > 0) {
            list.add((Component)Component.translatable((String)"tooltip.enchlib.item", (Object[])new Object[]{points}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != this) {
            world.removeBlockEntity(pos);
        }
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }
}

