/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import dev.shadowsoffire.apothic_enchanting.table.LegacyRarity;

public enum Arcana {
    EMPTY(0.0f, 10, 5, 2, 1),
    LITTLE(10.0f, 8, 5, 3, 1),
    FEW(20.0f, 7, 5, 4, 2),
    SOME(30.0f, 5, 5, 4, 2),
    LESS(40.0f, 5, 5, 4, 3),
    MEDIUM(50.0f, 5, 5, 5, 5),
    MORE(60.0f, 3, 4, 5, 5),
    VALUE(70.0f, 2, 4, 5, 5),
    EXTRA(80.0f, 2, 4, 5, 7),
    ALMOST(90.0f, 1, 3, 5, 8),
    MAX(99.0f, 1, 2, 5, 10);

    private final float threshold;
    private final int[] rarities;
    static Arcana[] VALUES;

    private Arcana(float threshold, int common, int uncommon, int rare, int veryRare) {
        this.threshold = threshold;
        this.rarities = new int[]{common, uncommon, rare, veryRare};
    }

    public int[] getRarities() {
        return this.rarities;
    }

    public int adjustWeight(int weight) {
        LegacyRarity rarity = LegacyRarity.byWeight(weight);
        return this.getRarities()[rarity.ordinal()];
    }

    public static Arcana getForThreshold(float threshold) {
        for (int i = VALUES.length - 1; i >= 0; --i) {
            if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
            return VALUES[i];
        }
        return EMPTY;
    }

    static {
        VALUES = Arcana.values();
    }
}

