/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.modules.cables.blocks.AdvancedConnectorTileEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.ModConfigSpec;
import terrails.xnetgases.Constants;
import terrails.xnetgases.I18nConstants;
import terrails.xnetgases.XNetGases;
import terrails.xnetgases.module.ChemicalMatcher;
import terrails.xnetgases.module.chemical.ChemicalChannelType;
import terrails.xnetgases.module.chemical.enums.ConnectorMode;

public class ChemicalConnectorSettings
extends AbstractConnectorSettings {
    public static final MapCodec<ChemicalConnectorSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractConnectorSettings.BaseSettings.CODEC.fieldOf("base").forGetter(settings -> settings.settings), (App)Direction.CODEC.fieldOf("side").forGetter(AbstractConnectorSettings::getSide), (App)ConnectorMode.CODEC.fieldOf("mode").forGetter(ChemicalConnectorSettings::getConnectorMode), (App)Codec.INT.optionalFieldOf("priority").forGetter(o -> Optional.ofNullable(o.priority)), (App)Codec.INT.optionalFieldOf("rate").forGetter(o -> Optional.ofNullable(o.transferRate)), (App)Codec.INT.optionalFieldOf("minmax").forGetter(o -> Optional.ofNullable(o.minMaxLimit)), (App)Codec.INT.fieldOf("speed").forGetter(ChemicalConnectorSettings::getOperationSpeed), (App)Codec.BOOL.fieldOf("rate_required").forGetter(ChemicalConnectorSettings::isTransferRateRequired), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("filter", (Object)ItemStack.EMPTY).forGetter(o -> o.matcher.getStack())).apply((Applicative)instance, ChemicalConnectorSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalConnectorSettings> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)AbstractConnectorSettings.BaseSettings.STREAM_CODEC, s -> s.settings, (StreamCodec)Direction.STREAM_CODEC, AbstractConnectorSettings::getSide, ConnectorMode.STREAM_CODEC, ChemicalConnectorSettings::getConnectorMode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.priority), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.transferRate), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.minMaxLimit), (StreamCodec)ByteBufCodecs.INT, ChemicalConnectorSettings::getOperationSpeed, (StreamCodec)ByteBufCodecs.BOOL, ChemicalConnectorSettings::isTransferRateRequired, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, s -> s.matcher.getStack(), ChemicalConnectorSettings::new);
    @Nullable
    private Integer priority = null;
    @Nullable
    private Integer transferRate = null;
    @Nullable
    private Integer minMaxLimit = null;
    private int operationSpeed = 20;
    private boolean transferRateRequired = false;
    private ConnectorMode connectorMode = ConnectorMode.INS;
    private ChemicalMatcher matcher = ChemicalMatcher.EMPTY;

    public ChemicalConnectorSettings(@Nonnull Direction side) {
        super(DEFAULT_SETTINGS, side);
    }

    public ChemicalConnectorSettings(@Nonnull AbstractConnectorSettings.BaseSettings base, @Nonnull Direction side, ConnectorMode mode, Optional<Integer> priority, Optional<Integer> rate, Optional<Integer> minMaxLimit, int speed, boolean transferRateRequired, ItemStack filter) {
        super(base, side);
        this.connectorMode = mode;
        this.priority = priority.orElse(null);
        this.transferRate = rate.orElse(null);
        this.minMaxLimit = minMaxLimit.orElse(null);
        this.operationSpeed = speed;
        this.transferRateRequired = transferRateRequired;
        this.matcher = ChemicalMatcher.from(filter);
    }

    public ConnectorMode getConnectorMode() {
        return this.connectorMode;
    }

    public int getOperationSpeed() {
        return this.operationSpeed;
    }

    public int getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getMinMaxLimit() {
        return this.minMaxLimit;
    }

    public Integer getTransferRate(BlockEntity connectorEntity) {
        ModConfigSpec.IntValue maxValue = connectorEntity instanceof AdvancedConnectorTileEntity ? XNetGases.maxRateAdvanced : XNetGases.maxRateNormal;
        return Optional.ofNullable(this.transferRate).orElseGet((Supplier<Integer>)maxValue);
    }

    public boolean isTransferRateRequired() {
        return this.transferRateRequired;
    }

    public ChemicalMatcher getMatcher() {
        return this.matcher;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.connectorMode = Optional.ofNullable(data.get("chemicalMode")).map(o -> ConnectorMode.values()[(Integer)o]).orElse(ConnectorMode.INS);
        this.transferRate = Optional.ofNullable(data.get("rate")).map(Integer.class::cast).flatMap(i -> i == -1 ? Optional.empty() : Optional.of(i)).orElse(null);
        this.transferRateRequired = Optional.ofNullable(data.get("rate_required")).map(Boolean.class::cast).orElse(false);
        this.minMaxLimit = Optional.ofNullable(data.get("minmax")).map(Integer.class::cast).flatMap(i -> i == -1 ? Optional.empty() : Optional.of(i)).orElse(null);
        this.priority = Optional.ofNullable(data.get("priority")).map(Integer.class::cast).filter(i -> i != 0).orElse(0);
        this.operationSpeed = Optional.ofNullable(data.get("speed")).map(String.class::cast).map(Integer::parseInt).filter(i -> i != 0).orElse(20);
        this.matcher = Optional.ofNullable(data.get("filter")).map(ItemStack.class::cast).map(ChemicalMatcher::from).orElse(ChemicalMatcher.EMPTY);
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        int maxTransferRate = (Integer)(this.advanced ? XNetGases.maxRateAdvanced : XNetGases.maxRateNormal).get();
        String[] speeds = (String[])Arrays.stream(this.advanced ? mcjty.xnet.apiimpl.Constants.ADVANCED_SPEEDS : mcjty.xnet.apiimpl.Constants.SPEEDS).map(s -> String.valueOf(Integer.parseInt(s) * 2)).toArray(String[]::new);
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        gui.translatableChoices("chemicalMode", (ITranslatableEnum)this.connectorMode, (ITranslatableEnum[])ConnectorMode.values());
        if (this.connectorMode == ConnectorMode.INS) {
            gui.label(mcjty.xnet.utils.I18nConstants.PRIORITY_LABEL.i18n(new Object[0])).integer("priority", mcjty.xnet.utils.I18nConstants.PRIORITY_TOOLTIP.i18n(new Object[0]), this.priority, 36);
        } else {
            gui.choices("speed", mcjty.xnet.utils.I18nConstants.SPEED_TOOLTIP.i18n(new Object[0]), Integer.toString(this.operationSpeed), speeds);
        }
        gui.nl();
        gui.label(mcjty.xnet.utils.I18nConstants.RATE_LABEL.i18n(new Object[0])).integer("rate", this.getRateTooltip(), this.transferRate, 60, maxTransferRate, -1);
        if (this.connectorMode == ConnectorMode.INS) {
            gui.shift(5);
            gui.toggle("rate_required", I18nConstants.REQUIRE_INSERT_RATE_LABEL.i18n(new Object[0]), this.transferRateRequired);
        }
        gui.nl();
        gui.label((this.connectorMode == ConnectorMode.EXT ? mcjty.xnet.utils.I18nConstants.MIN : mcjty.xnet.utils.I18nConstants.MAX).i18n(new Object[0])).integer("minmax", this.getMinMaxTooltip(), this.minMaxLimit, 48, Integer.MAX_VALUE, -1);
        gui.nl();
        gui.label(mcjty.xnet.utils.I18nConstants.FILTER_LABEL.i18n(new Object[0])).ghostSlot("filter", this.matcher.getStack());
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (this.connectorMode == ConnectorMode.INS) {
            return Constants.CHEMICAL_INSERT_FEATURES.contains(tag);
        }
        return Constants.CHEMICAL_EXTRACT_FEATURES.contains(tag);
    }

    public IChannelType getType() {
        return ChemicalChannelType.TYPE;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.getConnectorMode()) {
            default -> throw new MatchException(null, null);
            case ConnectorMode.INS -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 70, 13, 10);
            case ConnectorMode.EXT -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public JsonObject writeToJson() {
        JsonObject data = new JsonObject();
        super.writeToJsonInternal(data);
        data.add("rate_required", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.transferRateRequired)));
        ChemicalConnectorSettings.setEnumSafe((JsonObject)data, (String)"chemicalMode", (Enum)this.connectorMode);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"priority", (Integer)this.priority);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"rate", (Integer)this.transferRate);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"minmax", (Integer)this.minMaxLimit);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"speed", (Integer)this.operationSpeed);
        if (this.operationSpeed == 10 || this.transferRate != null && this.transferRate > (Integer)XNetGases.maxRateNormal.get()) {
            data.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (!this.matcher.isEmpty()) {
            data.add("filter", JSonTools.itemStackToJson((ItemStack)this.matcher.getStack()));
        }
        return data;
    }

    public void readFromJson(JsonObject data) {
        super.readFromJsonInternal(data);
        this.connectorMode = (ConnectorMode)ChemicalConnectorSettings.getEnumSafe((JsonObject)data, (String)"chemicalMode", ConnectorMode::byName);
        this.priority = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"priority");
        this.transferRate = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"rate");
        this.transferRateRequired = ChemicalConnectorSettings.getBoolSafe((JsonObject)data, (String)"rate_required");
        this.minMaxLimit = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"minmax");
        this.operationSpeed = ChemicalConnectorSettings.getIntegerNotNull((JsonObject)data, (String)"speed");
        if (this.operationSpeed == 0) {
            this.operationSpeed = 20;
        }
        this.matcher = Optional.ofNullable(data.get("filter")).map(JsonElement::getAsJsonObject).map(JSonTools::jsonToItemStack).map(ChemicalMatcher::from).orElse(ChemicalMatcher.EMPTY);
    }

    private String getRateTooltip() {
        return I18nConstants.CHEMICAL_RATE_TOOLTIP_FORMATTED.i18n((this.getConnectorMode() == ConnectorMode.EXT ? mcjty.xnet.utils.I18nConstants.EXT_ENDING : mcjty.xnet.utils.I18nConstants.INS_ENDING).i18n(new Object[0]), (this.advanced ? XNetGases.maxRateAdvanced : XNetGases.maxRateNormal).get());
    }

    private String getMinMaxTooltip() {
        return I18nConstants.CHEMICAL_MINMAX_TOOLTIP_FORMATTED.i18n((this.getConnectorMode() == ConnectorMode.EXT ? mcjty.xnet.utils.I18nConstants.EXT_ENDING : mcjty.xnet.utils.I18nConstants.INS_ENDING).i18n(new Object[0]), (this.getConnectorMode() == ConnectorMode.EXT ? mcjty.xnet.utils.I18nConstants.LOW_FORMAT : mcjty.xnet.utils.I18nConstants.HIGH_FORMAT).i18n(new Object[0]));
    }
}

