/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data.client;

import java.util.function.Supplier;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class LanguageGenerator
extends LanguageProvider {
    public LanguageGenerator(PackOutput packOutput) {
        super(packOutput, "constructionstick", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.constructionstick.tab", "Construction Sticks");
        this.addItem((Supplier)ModItems.STICK_WOODEN, "Stickiest Stick");
        this.addItem((Supplier)ModItems.STICK_COPPER, "Copper Stick");
        this.addItem((Supplier)ModItems.STICK_IRON, "Iron Stick");
        this.addItem((Supplier)ModItems.STICK_DIAMOND, "Diamond Stick");
        this.addItem((Supplier)ModItems.STICK_NETHERITE, "Netherite Stick");
        this.addItem((Supplier)ModItems.TEMPLATE_ANGEL, "Angel Stick Template");
        this.addItem((Supplier)ModItems.TEMPLATE_DESTRUCTION, "Destruction Stick Template");
        this.addItem((Supplier)ModItems.TEMPLATE_REPLACEMENT, "Replacement Stick Template");
        this.addItem((Supplier)ModItems.TEMPLATE_UNBREAKABLE, "Unbreakable Template");
        this.addItem((Supplier)ModItems.TEMPLATE_BATTERY, "Battery Template");
        this.add("constructionstick.tooltip.storage", "%s/%s RF stored");
        this.add("constructionstick.tooltip.blocks", "Max. %d blocks");
        this.add("constructionstick.tooltip.shift", "Press [SHIFT]");
        this.add("constructionstick.tooltip.upgrades", "Stick upgrades:");
        this.add("constructionstick.tooltip.upgrades_tip", "Apply the template to your stick in the smithing table");
        this.add("constructionstick.option.upgrades", "");
        this.addUpgradeInfo("default", "Construction", "Extend your building on the side facing you");
        this.addUpgradeInfo("upgrade_angel", "\u00a76Angel", "Place behind blocks and in mid air");
        this.addUpgradeInfo("upgrade_destruction", "\u00a7cDestruction", "Destroys blocks on the side facing you");
        this.addUpgradeInfo("upgrade_replacement", "\u00a75Replacement", "Replaces blocks with the block in your offhand");
        this.addUpgradeInfo("upgrade_unbreakable", "\u00a7dUnbreakable", "Allows placing without using durability");
        this.addUpgradeInfo("upgrade_battery", "\u00a74Battery", "Use energy instead of durability");
        this.add("constructionstick.option.lock", "Restriction: ");
        this.add("constructionstick.option.lock.horizontal", "\u00a7aLeft/Right");
        this.add("constructionstick.option.lock.horizontal.desc", "Build a horizontal column in front of the original block");
        this.add("constructionstick.option.lock.vertical", "\u00a7aUp/Down");
        this.add("constructionstick.option.lock.vertical.desc", "Build a vertical column in front of the original block");
        this.add("constructionstick.option.lock.northsouth", "\u00a76North/South");
        this.add("constructionstick.option.lock.northsouth.desc", "Build a row in N/S direction on top of the original block");
        this.add("constructionstick.option.lock.eastwest", "\u00a76East/West");
        this.add("constructionstick.option.lock.eastwest.desc", "Build a row in E/W direction on top of the original block");
        this.add("constructionstick.option.lock.nolock", "\u00a7cNone");
        this.add("constructionstick.option.lock.nolock.desc", "Extend from any side of the original block");
        this.add("constructionstick.option.direction", "Direction: ");
        this.add("constructionstick.option.direction.target", "\u00a76Target");
        this.add("constructionstick.option.direction.target.desc", "Place blocks with same direction as target block");
        this.add("constructionstick.option.direction.player", "\u00a7aPlayer");
        this.add("constructionstick.option.direction.player.desc", "Place blocks facing the player");
        this.add("constructionstick.option.replace", "Replacement: ");
        this.add("constructionstick.option.replace.yes", "\u00a7aYes");
        this.add("constructionstick.option.replace.yes.desc", "Replace certain blocks like fluids, snow and tallgrass");
        this.add("constructionstick.option.replace.no", "\u00a7cNo");
        this.add("constructionstick.option.replace.no.desc", "Don't replace blocks");
        this.add("constructionstick.option.match", "Matching: ");
        this.add("constructionstick.option.match.exact", "\u00a7aExact");
        this.add("constructionstick.option.match.exact.desc", "Only extend blocks that are exactly the same");
        this.add("constructionstick.option.match.similar", "\u00a76Similar");
        this.add("constructionstick.option.match.similar.desc", "Treat similar blocks (dirt/grass types) equally");
        this.add("constructionstick.option.match.any", "\u00a7cAny");
        this.add("constructionstick.option.match.any.desc", "Extend any block");
        this.add("constructionstick.option.random", "Random: ");
        this.add("constructionstick.option.random.yes", "\u00a7aYes");
        this.add("constructionstick.option.random.yes.desc", "Place random blocks present in your hotbar");
        this.add("constructionstick.option.random.no", "\u00a7cNo");
        this.add("constructionstick.option.random.no.desc", "Don't randomize placed blocks");
        this.add("constructionstick.description.stick", "The %s can place up to %s blocks at the side of a building facing you and lasts %s.\n\nPress the bound %s key to change placement restriction (Horizontal, Vertical, North/South, East/West, No lock).\n\nOpen the option screen with the bound %s key.\n\n\u00a75\u00a7nUNDO\u00a70\u00a7r\nHolding down the bound %s key while looking at a blocks will show you the last blocks you placed with a green border around them. Pressing the bound %s key while looking at any of them will undo the operation, giving you all the items back. If you used the Destruction upgrade, it will restore the blocks.\n\n\u00a75\u00a7nCONTAINERS\u00a70\u00a7r\nShulker boxes, bundles and many containers from other mods can provide building blocks for the stick.\n\n\u00a75\u00a7nOFFHAND PRIORITY\u00a70\u00a7r\nHaving blocks in your offhand will place them instead of the block you're looking at.");
        this.add("constructionstick.description.durability.limited", "for %d blocks");
        this.add("constructionstick.description.key.sneak", "Sneak");
        this.add("constructionstick.description.key.sneak_opt", "Sneak+%s");
        this.add("constructionstick.description.upgrade", "\u00a75\u00a7nINSTALLATION\u00a70\u00a7r\nPut your new upgrade template together with your stick and the required item in a Smithing Table to apply (Check the Smithing Table recipes to see the required item). To switch between upgrades, press the bound %s key while holding your stick or use the option screen.");
        this.add("constructionstick.description.template_angel", "The angel upgrade places a block on the opposite side of the block (or row of blocks) you are facing. Maximum distance depends on stick tier. Right click empty space to place a block in midair. To do that, you'll need to have the block you want to place in your offhand.");
        this.add("constructionstick.description.template_destruction", "The destruction upgrade destroys blocks (no block entities) on the side facing you. Maximum number of blocks depends on stick tier. Destroyed blocks disappear into the void, you can use the undo feature if you've made a mistake.");
        this.add("constructionstick.description.template_replacement", "The replacement upgrade allows you to exchange blocks with the block of the type you are holding in your offhand. This can be useful for replacing walls after placement.");
        this.add("constructionstick.description.template_unbreakable", "The unbreakable upgrade allows you to place blocks without using durability. The stick will never break.");
        this.add("constructionstick.description.template_battery", "The battery upgrade allows you to use energy instead of durability. The stick will have the ability to store energy and use it to place blocks. Warning, you can only charge the stick if you have a mod that provides a way to do so.");
        this.add("stat.constructionstick.use_stick", "Blocks placed using Stick");
        this.addKeybind("category", "Construction Sticks");
        this.addKeybind("change_restriction", "Toggle Restriction");
        this.addKeybind("change_upgrade", "Toggle Upgrade");
        this.addKeybind("change_direction", "Toggle Direction");
        this.addKeybind("open_gui", "Open Stick Options");
        this.addKeybind("undo", "Undo Operation");
        this.addKeybind("show_previous", "Show Previous");
        this.add("constructionstick.networking.query_undo.failed", "Failed to undo operation: %s");
        this.add("constructionstick.networking.stick_option.undo", "Failed to change stick option: %s");
        this.add("constructionstick.networking.undo_blocks.failed", "Failed to undo blocks: %s");
        this.add("constructionstick.placement.denied", "This block cannot be placed with the Construction Stick!");
        this.add("constructionstick.alias.emi.construction", "Construction");
        this.add("constructionstick.alias.emi.wand", "Wand");
        this.add("constructionstick.alias.emi.construction_wand", "Construction Wand");
        this.addAdvancement("root", "Construction Sticks", "Making building easier");
        this.addAdvancement("iron_stick", "Sticky Situation", "Craft any Construction Stick");
        this.addAdvancement("template_angel", "Angel Stick Template", "I'm placing in mid-air, wo-oah!");
        this.addAdvancement("template_destruction", "Destruction Stick Template", "Destroyer of blocks");
        this.addAdvancement("template_replacement", "Replacement Stick Template", "Out with the old, in with the new");
        this.addAdvancement("template_unbreakable", "Unbreakable Template", "There's no limit!");
        this.addAdvancement("template_battery", "Battery Template", "Power up your construction game");
        this.addConfig(ModItems.STICK_WOODEN.getId().getPath(), "Stickiest Stick", "Stickiest Stick Settings");
        this.addConfig(ModItems.STICK_COPPER.getId().getPath(), "Copper Stick", "Copper Stick Settings");
        this.addConfig(ModItems.STICK_IRON.getId().getPath(), "Iron Stick", "Iron Stick Settings");
        this.addConfig(ModItems.STICK_DIAMOND.getId().getPath(), "Diamond Stick", "Diamond Stick Settings");
        this.addConfig(ModItems.STICK_NETHERITE.getId().getPath(), "Netherite Stick", "Netherite Stick Settings");
        this.addConfig("durability", "Durability", "Stick durability");
        this.addConfig("batteryStorage", "Battery Storage", "Battery power storage");
        this.addConfig("batteryUsage", "Battery Usage", "Battery power usage per block");
        this.addConfig("limit", "Placement Limit", "Max placement distance with angel upgrade (0 to disable angel upgrade)");
        this.addConfig("angel", "Angel Upgrade", "Stick destruction block limit (0 to disable destruction upgrade)");
        this.addConfig("destruction", "Destruction Upgrade", "Stick destruction block limit (0 to disable destruction upgrade)");
        this.addConfig("upgradeable", "Upgradeable", "Allow stick upgrading by putting the stick together with a stick upgrade in a smithing table.");
        this.addConfig("misc", "Misc", "Miscellaneous Settings");
        this.addConfig("MaxRange", "Max Range", "Maximum placement range (0: unlimited). Affects all sticks and is meant for lag prevention, not game balancing.");
        this.addConfig("UndoHistory", "Undo History", "Number of operations that can be undone");
        this.addConfig("AngelFalling", "Angel Falling", "Place blocks below you while falling > 10 blocks with angel upgrade (Can be used to save you from drops/the void)");
        this.addConfig("SimilarBlocks", "Similar Blocks", "Blocks to treat equally when in Similar mode. Enter block IDs separated by ;");
        this.addConfig("blockentity", "Block entity", "Block Entity Settings");
        this.addConfig("BEList", "Block Entity List", "White/Blacklist for Block Entities. Allow/Prevent blocks with BEs from being placed by stick. You can either add block ids like minecraft:chest or mod ids like minecraft");
        this.addConfig("BEWhitelist", "Block Entity Whitelist", "If set to TRUE, treat BEList as a whitelist, otherwise blacklist");
    }

    private void addKeybind(String path, String translation) {
        this.add("key.constructionstick." + path, translation);
    }

    private void addUpgradeInfo(String upgrade, String name, String desc) {
        this.add("constructionstick.option.upgrades.constructionstick:" + upgrade, name);
        this.add("constructionstick.option.upgrades.constructionstick:" + upgrade + ".desc", desc);
    }

    private void addAdvancement(String id, String name, String description) {
        String prefix = "advancement.constructionstick.";
        this.add(prefix + id + ".title", name);
        this.add(prefix + id + ".desc", description);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("constructionstick.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("constructionstick.configuration." + path + ".tooltip", description);
        }
    }
}

