/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.setworldspawnpoint_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.setworldspawnpoint_common_neoforge.config.ConfigHandler;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;

public class WorldSpawnEvent {
    public static boolean onWorldLoad(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        if (Services.MODLOADER.isModLoaded("villagespawnpoint") || Services.MODLOADER.isModLoaded("biomespawnpoint")) {
            return false;
        }
        int x = ConfigHandler.xCoordSpawnPoint;
        int y = ConfigHandler.yCoordSpawnPoint;
        int z = ConfigHandler.zCoordSpawnPoint;
        if (y < 0) {
            BlockPos surfacepos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)x, (int)z);
            y = surfacepos.getY();
        }
        BlockPos spawnpos = new BlockPos(x, y, z);
        serverLevel.setDefaultSpawnPos(spawnpos, 1.0f);
        return true;
    }

    public static void onPlayerRespawn(ServerPlayer oldPlayer, ServerPlayer player, boolean alive) {
        Level world = player.level();
        if (world.isClientSide) {
            return;
        }
        if (ConfigHandler._forceExactSpawn) {
            DimensionTransition optionalbed;
            ServerLevel serverworld = (ServerLevel)world;
            BlockPos respawnlocation = serverworld.getSharedSpawnPos();
            Vec3 respawnvec = new Vec3((double)respawnlocation.getX(), (double)respawnlocation.getY(), (double)respawnlocation.getZ());
            BlockPos bedpos = player.getRespawnPosition();
            if (bedpos != null && !(optionalbed = player.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING)).missingRespawnBlock()) {
                Vec3 bedlocation = optionalbed.pos();
                BlockPos bl = BlockPos.containing((double)bedlocation.x(), (double)bedlocation.y(), (double)bedlocation.z());
                Iterator it = BlockPos.betweenClosedStream((int)(bl.getX() - 1), (int)(bl.getY() - 1), (int)(bl.getZ() - 1), (int)(bl.getX() + 1), (int)(bl.getY() + 1), (int)(bl.getZ() + 1)).iterator();
                while (it.hasNext()) {
                    BlockPos np = (BlockPos)it.next();
                    BlockState state = world.getBlockState(np);
                    Block block = state.getBlock();
                    if (!(block instanceof BedBlock) || !((BedPart)state.getValue((Property)BedBlock.PART)).equals((Object)BedPart.FOOT)) continue;
                    bedlocation = new Vec3((double)np.getX() + 0.5, (double)np.getY(), (double)np.getZ() + 0.5);
                    break;
                }
                respawnvec = new Vec3(bedlocation.x(), bedlocation.y(), bedlocation.z());
            }
            player.teleportTo(respawnvec.x, respawnvec.y, respawnvec.z);
        }
    }

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (!ConfigHandler._forceExactSpawn) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!PlayerFunctions.isJoiningWorldForTheFirstTime((Player)player, (String)"setworldspawnpoint")) {
            return;
        }
        ServerLevel serverworld = (ServerLevel)level;
        BlockPos wspos = serverworld.getSharedSpawnPos();
        BlockPos ppos = player.blockPosition();
        BlockPos cpos = new BlockPos(ppos.getX(), wspos.getY(), ppos.getZ());
        if (cpos.closerThan((Vec3i)wspos, 50.0)) {
            player.teleportTo((double)wspos.getX(), (double)wspos.getY(), (double)wspos.getZ());
        }
    }
}

