/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClientBoundSyncWorldDataMessage<D extends WorldSavedData>
implements Message {
    private final D data;
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundSyncWorldDataMessage<?>> TYPE = Message.makeType(Moonlight.res("s2c_sync_world_data"), ClientBoundSyncWorldDataMessage::fromNetwork);

    public ClientBoundSyncWorldDataMessage(D data) {
        this.data = data;
    }

    private static ClientBoundSyncWorldDataMessage<?> fromNetwork(RegistryFriendlyByteBuf buffer) {
        WorldSavedDataType type = (WorldSavedDataType)WorldSavedDataType.STREAM_CODEC.decode((Object)buffer);
        return new ClientBoundSyncWorldDataMessage<WorldSavedData>((WorldSavedData)((Object)((StreamCodec)Preconditions.checkNotNull(type.getStreamCodec())).decode((Object)buffer)));
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        WorldSavedDataType<? extends WorldSavedData> type = ((WorldSavedData)((Object)this.data)).getType();
        WorldSavedDataType.STREAM_CODEC.encode((Object)buf, type);
        ((StreamCodec)Preconditions.checkNotNull(type.getStreamCodec())).encode((Object)buf, this.data);
    }

    @Override
    public void handle(Message.Context context) {
        ClientBoundSyncWorldDataMessage.handleSyncWorldData(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSyncWorldData(ClientBoundSyncWorldDataMessage<?> message) {
        ClientLevel l = Minecraft.getInstance().level;
        WorldSavedDataType<? extends WorldSavedData> type = ((WorldSavedData)((Object)message.data)).getType();
        type.setData((Level)l, (WorldSavedData)((Object)message.data));
        Moonlight.LOGGER.info("Synced Custom World Data [{}]", (Object)type.getName());
    }
}

