/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.worldgen;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.worldgen.ISpawnBoxStructure;
import net.mehvahdjukaar.moonlight.api.worldgen.SpawnBoxSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class JigsawCodecWithExtra
extends MapCodec<JigsawStructure> {
    private static final String BOX_KEY = "spawn_boxes";
    private static final MapCodec<SpawnBoxSettings> BOX_CODEC = SpawnBoxSettings.CODEC.optionalFieldOf("spawn_boxes", (Object)SpawnBoxSettings.EMPTY);
    private final MapCodec<JigsawStructure> original;

    public JigsawCodecWithExtra(MapCodec<JigsawStructure> original) {
        this.original = original;
    }

    public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
        return Stream.concat(this.original.keys(dynamicOps), Stream.of(dynamicOps.createString(BOX_KEY)));
    }

    public <T> DataResult<JigsawStructure> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
        Structure value;
        DataResult result = this.original.decode(dynamicOps, mapLike);
        DataResult boxResult = BOX_CODEC.decode(dynamicOps, mapLike);
        if (boxResult.isError()) {
            return DataResult.error(() -> ((DataResult.Error)boxResult.error().get()).message());
        }
        if (result.isSuccess() && (value = (Structure)result.getOrThrow()) instanceof ISpawnBoxStructure) {
            ISpawnBoxStructure sb = (ISpawnBoxStructure)value;
            sb.ml$setSpawnBoxSettings((SpawnBoxSettings)boxResult.getOrThrow());
        }
        return result;
    }

    public <T> RecordBuilder<T> encode(JigsawStructure jigsawStructure, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
        ISpawnBoxStructure sb;
        SpawnBoxSettings s;
        RecordBuilder rb = this.original.encode((Object)jigsawStructure, dynamicOps, recordBuilder);
        JigsawStructure str = jigsawStructure;
        if (str instanceof ISpawnBoxStructure && !(s = (sb = (ISpawnBoxStructure)str).ml$getSpawnBoxSettings()).isEmpty()) {
            rb = BOX_CODEC.encode((Object)s, dynamicOps, rb);
        }
        return rb;
    }
}

