/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import snownee.jade.Jade;
import snownee.jade.api.JadeIds;
import snownee.jade.network.ClientPayloadContext;

public record ShowOverlayPacket(boolean show) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShowOverlayPacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_SHOW_OVERLAY);
    public static final StreamCodec<RegistryFriendlyByteBuf, ShowOverlayPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ShowOverlayPacket::show, ShowOverlayPacket::new);

    public static void handle(ShowOverlayPacket message, ClientPayloadContext context) {
        Jade.LOGGER.info("Received request from the server to {} overlay", (Object)(message.show ? "show" : "hide"));
        context.execute(() -> {
            Jade.CONFIG.get().getGeneral().setDisplayTooltip(message.show);
            Jade.CONFIG.save();
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

