/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PNCCapabilities {
    public static final EntityCapability<IAirHandler, Void> AIR_HANDLER_ENTITY = EntityCapability.createVoid((ResourceLocation)PneumaticRegistry.RL("air_handler_entity"), IAirHandler.class);
    public static final BlockCapability<IAirHandlerMachine, Direction> AIR_HANDLER_MACHINE = BlockCapability.createSided((ResourceLocation)PneumaticRegistry.RL("air_handler_machine"), IAirHandlerMachine.class);
    public static final ItemCapability<IAirHandlerItem, Void> AIR_HANDLER_ITEM = ItemCapability.createVoid((ResourceLocation)PneumaticRegistry.RL("air_handler_item"), IAirHandlerItem.class);
    public static final BlockCapability<IHeatExchangerLogic, Direction> HEAT_EXCHANGER_BLOCK = BlockCapability.createSided((ResourceLocation)PneumaticRegistry.RL("heat_exchanger_block"), IHeatExchangerLogic.class);
    public static final EntityCapability<IHeatExchangerLogic, Void> HEAT_EXCHANGER_ENTITY = EntityCapability.createVoid((ResourceLocation)PneumaticRegistry.RL("heat_exchanger_entity"), IHeatExchangerLogic.class);
    public static final ItemCapability<IFilteringItem, Void> ITEM_FILTERING = ItemCapability.createVoid((ResourceLocation)PneumaticRegistry.RL("item_filtering"), IFilteringItem.class);
    public static final EntityCapability<IItemHandler, @Nullable Direction> ENTITY_AUTOMATION = EntityCapability.createSided((ResourceLocation)PneumaticRegistry.RL("item_handler_automation"), IItemHandler.class);

    public static Optional<IAirHandlerItem> getAirHandler(ItemStack stack) {
        return Optional.ofNullable((IAirHandlerItem)stack.getCapability(AIR_HANDLER_ITEM));
    }

    public static Optional<IAirHandlerMachine> getAirHandler(BlockEntity blockEntity, Direction direction) {
        return blockEntity.getLevel() == null ? Optional.empty() : Optional.ofNullable((IAirHandlerMachine)blockEntity.getLevel().getCapability(AIR_HANDLER_MACHINE, blockEntity.getBlockPos(), (Object)direction));
    }

    public static Optional<IAirHandlerMachine> getAirHandler(BlockEntity blockEntity) {
        return PNCCapabilities.getAirHandler(blockEntity, null);
    }

    public static Optional<IAirHandler> getAirHandler(Entity entity) {
        return Optional.ofNullable((IAirHandler)entity.getCapability(AIR_HANDLER_ENTITY));
    }

    public static Optional<IHeatExchangerLogic> getHeatLogic(BlockEntity blockEntity, Direction direction) {
        return Optional.ofNullable((IHeatExchangerLogic)blockEntity.getLevel().getCapability(HEAT_EXCHANGER_BLOCK, blockEntity.getBlockPos(), (Object)direction));
    }

    public static Optional<IHeatExchangerLogic> getHeatLogic(BlockEntity blockEntity) {
        return PNCCapabilities.getHeatLogic(blockEntity, null);
    }

    public static Optional<IFilteringItem> getItemFiltering(ItemStack stack) {
        return Optional.ofNullable((IFilteringItem)stack.getCapability(ITEM_FILTERING));
    }
}

