/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class TubeModuleClientRegistry {
    private static final Map<ResourceLocation, ModuleRendererFactory<?>> MODEL_FACTORY = new ConcurrentHashMap();
    private static final Map<ResourceLocation, Function<? extends AbstractTubeModule, ? extends AbstractTubeModuleScreen<?>>> GUI_FACTORY = new ConcurrentHashMap();

    static void registerTubeModuleRenderer(ResourceLocation moduleType, ModuleRendererFactory<?> factory) {
        MODEL_FACTORY.put(moduleType, factory);
    }

    static <T extends AbstractTubeModule> void registerTubeModuleGUI(ResourceLocation moduleType, Function<T, ? extends AbstractTubeModuleScreen<T>> factory) {
        GUI_FACTORY.put(moduleType, factory);
    }

    public static <T extends AbstractTubeModule> AbstractTubeModuleScreen<T> createGUI(T module) {
        Function<AbstractTubeModule, AbstractTubeModuleScreen<?>> factory = GUI_FACTORY.get(module.getType());
        return factory == null ? null : factory.apply(module);
    }

    public static <T extends AbstractTubeModule> AbstractTubeModuleRenderer<T> createModel(T module, BlockEntityRendererProvider.Context ctx) {
        return (AbstractTubeModuleRenderer)MODEL_FACTORY.get(module.getType()).apply(ctx);
    }

    public static interface ModuleRendererFactory<T extends AbstractTubeModuleRenderer<?>>
    extends Function<BlockEntityRendererProvider.Context, T> {
    }
}

