/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.SearchOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderSearchItemBlock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SearchHandler;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class SearchClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<SearchHandler> {
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = StatPanelLayout.expandsRight(0.005f, 0.1f);
    private int totalSearchedItemCount;
    private int itemSearchCount;
    private int ticksExisted;
    private final Map<ItemEntity, Integer> searchedItems = new HashMap<ItemEntity, Integer>();
    private final Map<BlockEntity, RenderSearchItemBlock> trackedInventories = new HashMap<BlockEntity, RenderSearchItemBlock>();
    private IGuiAnimatedStat searchInfo;
    private ItemStack searchedStack = ItemStack.EMPTY;

    public SearchClientHandler() {
        super(CommonUpgradeHandlers.searchHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        if (!isEnabled) {
            return;
        }
        ++this.ticksExisted;
        if ((this.ticksExisted & 0xF) == 0) {
            int rangeUpgrades = armorHandler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.RANGE.get());
            int blockSearchCount = this.trackInventoryCounts(rangeUpgrades);
            if (armorHandler.upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true)) {
                this.trackItemEntities(rangeUpgrades);
            }
            this.searchedItems.entrySet().removeIf(e -> !((ItemEntity)e.getKey()).isAlive());
            this.totalSearchedItemCount = this.itemSearchCount + blockSearchCount;
        }
        Item item = PneumaticArmorItem.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlot.HEAD));
        ArrayList<Component> textList = new ArrayList<Component>();
        if (item == null || item == Items.AIR) {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.search.configure", KeyHandler.getInstance().keybindOpenOptions.getTranslatedKeyMessage()));
        } else {
            if (this.searchedStack.getItem() != item) {
                this.searchedStack = new ItemStack((ItemLike)item);
            }
            textList.add((Component)this.searchedStack.getHoverName().copy().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.search.found", this.totalSearchedItemCount)));
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        VertexConsumer builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.GLOW_RESOURCE, true));
        this.searchedItems.forEach((item, value) -> {
            float height = Mth.sin((float)(((float)item.getAge() + partialTicks) / 10.0f + item.bobOffs)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(matrixStack, builder, item.xOld + (item.getX() - item.xOld) * (double)partialTicks, item.yOld + (item.getY() - item.yOld) * (double)partialTicks + (double)height, item.zOld + (item.getZ() - item.zOld) * (double)partialTicks, value, this.totalSearchedItemCount, partialTicks);
        });
        this.trackedInventories.values().forEach(entry -> entry.renderSearchBlock(matrixStack, builder, this.totalSearchedItemCount, partialTicks));
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
    }

    private int trackInventoryCounts(int rangeUpgrades) {
        int blockSearchCount = 0;
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        Player player = ClientUtils.getClientPlayer();
        ArrayList<BlockEntity> toRemove = new ArrayList<BlockEntity>();
        for (Map.Entry<BlockEntity, RenderSearchItemBlock> entry : this.trackedInventories.entrySet()) {
            BlockEntity blockEntity = entry.getKey();
            if (blockEntity.isRemoved() || blockEntity.getBlockPos().distSqr((Vec3i)player.blockPosition()) > (double)blockTrackRangeSq) {
                toRemove.add(blockEntity);
                continue;
            }
            blockSearchCount += entry.getValue().getSearchedItemCount();
        }
        toRemove.forEach(this.trackedInventories::remove);
        return blockSearchCount;
    }

    private void trackItemEntities(int rangeUpgrades) {
        this.searchedItems.clear();
        this.itemSearchCount = 0;
        Item searchedItem = PneumaticArmorItem.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlot.HEAD));
        if (searchedItem == null || searchedItem == Items.AIR) {
            return;
        }
        Player player = ClientUtils.getClientPlayer();
        List items = player.level().getEntitiesOfClass(ItemEntity.class, EntityTrackerClientHandler.getAABBFromRange(player, rangeUpgrades));
        for (ItemEntity itemEntity : items) {
            if (itemEntity.getItem().isEmpty()) continue;
            if (itemEntity.getItem().getItem() == searchedItem) {
                this.searchedItems.put(itemEntity, itemEntity.getItem().getCount());
                this.itemSearchCount += itemEntity.getItem().getCount();
                continue;
            }
            List<ItemStack> inventoryItems = ItemRegistry.getInstance().getStacksInItem(itemEntity.getItem());
            int itemCount = 0;
            for (ItemStack inventoryItem : inventoryItems) {
                if (inventoryItem.getItem() != searchedItem) continue;
                itemCount += inventoryItem.getCount();
            }
            if (itemCount <= 0) continue;
            this.searchedItems.put(itemEntity, itemCount);
            this.itemSearchCount += itemCount;
        }
    }

    void onBlockTrackStart(BlockEntity blockEntity) {
        if (WidgetKeybindCheckBox.isHandlerEnabled(CommonUpgradeHandlers.searchHandler)) {
            Item searchedItem = PneumaticArmorItem.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlot.HEAD));
            if (searchedItem != null) {
                IOHelper.getInventoryForBlock(blockEntity).ifPresent(handler -> {
                    if (this.checkForItems((IItemHandler)handler, searchedItem)) {
                        this.trackedInventories.put(blockEntity, new RenderSearchItemBlock(blockEntity.getLevel(), blockEntity.getBlockPos()));
                    }
                });
            }
        } else {
            this.trackedInventories.clear();
        }
    }

    private boolean checkForItems(IItemHandler handler, Item item) {
        for (int l = 0; l < handler.getSlots(); ++l) {
            int items;
            if (handler.getStackInSlot(l).isEmpty() || (items = RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), item)) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.trackedInventories.clear();
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new SearchOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            ItemStack icon = ModUpgrades.SEARCH.get().getItemStack();
            this.searchInfo = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.search.searchingFor", new Object[0]), icon, this);
            this.searchInfo.setMinimumContractedDimensions(0, 0);
        }
        return this.searchInfo;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    @Override
    public void onResolutionChanged() {
        this.searchInfo = null;
    }
}

