/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.misc.IPneumaticCraftProbeable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.SerializableComponentsProvider;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public abstract class AbstractPneumaticCraftBlock
extends Block
implements IPneumaticWrenchable,
IPneumaticCraftProbeable,
SimpleWaterloggedBlock,
SerializableComponentsProvider {
    static final VoxelShape ALMOST_FULL_SHAPE = Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty[] CONNECTION_PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    protected AbstractPneumaticCraftBlock(BlockBehaviour.Properties props) {
        super(props);
        if (this.defaultBlockState().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean canPlaceLiquid(Player player, BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return pState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && super.canPlaceLiquid(player, pLevel, pPos, pState, pFluid);
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return pState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && super.placeLiquid(pLevel, pPos, pState, pFluidState);
    }

    public ItemStack pickupBlock(Player player, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        return pState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? super.pickupBlock(player, pLevel, pPos, pState) : ItemStack.EMPTY;
    }

    public FluidState getFluidState(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isWaterloggable() {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te = level.getBlockEntity(pos);
        if (player.isShiftKeyDown() || !(te instanceof MenuProvider) || this.isRotatable() && (heldItem.getItem() == ModItems.MANOMETER.get() || ModdedWrenchUtils.getInstance().isModdedWrench(heldItem)) || hand == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(player.getMainHandItem())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                if (FluidUtils.tryFluidInsertion(te, null, player, hand)) {
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
                if (FluidUtils.tryFluidExtraction(te, null, player, hand)) {
                    level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
                this.doOpenGui(serverPlayer, te);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)true);
    }

    protected void doOpenGui(ServerPlayer player, BlockEntity te) {
        player.openMenu((MenuProvider)te, te.getBlockPos());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state != null) {
            for (Direction facing : DirectionUtil.VALUES) {
                if (!state.hasProperty((Property)AbstractPneumaticCraftBlock.connectionProperty(facing))) continue;
                BlockEntity neighbourBE = ctx.getLevel().getBlockEntity(ctx.getClickedPos().relative(facing));
                boolean isConnected = neighbourBE != null && PNCCapabilities.getAirHandler(neighbourBE, facing.getOpposite()).isPresent();
                state = (BlockState)state.setValue((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(isConnected));
            }
            if (this.isRotatable()) {
                Direction f = this.canRotateToTopOrBottom() ? ctx.getNearestLookingDirection() : ctx.getHorizontalDirection();
                state = (BlockState)state.setValue((Property)this.directionProperty(), (Comparable)(this.reversePlacementRotation() ? f.getOpposite() : f));
            }
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
                state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
            }
        }
        return state;
    }

    protected boolean reversePlacementRotation() {
        return false;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof AbstractPneumaticCraftBlockEntity) {
            AbstractPneumaticCraftBlockEntity pncTE = (AbstractPneumaticCraftBlockEntity)te;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                pncTE.setCustomName(stack.getHoverName());
            }
        }
        if (te instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)te;
            he.initHeatExchangersOnPlacement(world, pos);
        }
    }

    public static BooleanProperty connectionProperty(Direction dir) {
        return CONNECTION_PROPERTIES[dir.get3DDataValue()];
    }

    DirectionProperty directionProperty() {
        return this.canRotateToTopOrBottom() ? BlockStateProperties.FACING : BlockStateProperties.HORIZONTAL_FACING;
    }

    protected Direction getRotation(BlockGetter world, BlockPos pos) {
        return this.getRotation(world.getBlockState(pos));
    }

    public Direction getRotation(BlockState state) {
        return (Direction)state.getValue((Property)this.directionProperty());
    }

    protected void setRotation(Level world, BlockPos pos, Direction rotation) {
        this.setRotation(world, pos, rotation, world.getBlockState(pos));
    }

    private void setRotation(Level world, BlockPos pos, Direction rotation, BlockState state) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.directionProperty(), (Comparable)rotation));
    }

    public boolean isRotatable() {
        return false;
    }

    protected boolean canRotateToTopOrBottom() {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.isRotatable()) {
            builder.add(new Property[]{this.directionProperty()});
        }
        if (this.isWaterloggable()) {
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (this.isRotatable()) {
            state = (BlockState)state.setValue((Property)this.directionProperty(), (Comparable)rotation.rotate((Direction)state.getValue((Property)this.directionProperty())));
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.isRotatable() ? state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)this.directionProperty()))) : state;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player != null && player.isShiftKeyDown()) {
            BlockEntity te = world.getBlockEntity(pos);
            boolean preserve = false;
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                AbstractPneumaticCraftBlockEntity pncBE = (AbstractPneumaticCraftBlockEntity)te;
                preserve = true;
                pncBE.setPreserveStateOnBreak(true);
            }
            if (!player.isCreative() || preserve) {
                Block.dropResources((BlockState)world.getBlockState(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)te);
            }
            AbstractPneumaticCraftBlock.removeBlockSneakWrenched(world, pos);
            return true;
        }
        if (this.isRotatable()) {
            BlockState state = world.getBlockState(pos);
            if (!this.rotateCustom(world, pos, state, side)) {
                if (this.rotateForgeWay()) {
                    if (!this.canRotateToTopOrBottom()) {
                        side = Direction.UP;
                    }
                    if (this.getRotation((BlockGetter)world, pos).getAxis() != side.getAxis()) {
                        this.setRotation(world, pos, DirectionUtil.rotateAround(this.getRotation((BlockGetter)world, pos), side.getAxis()));
                    }
                } else {
                    Direction f = this.getRotation((BlockGetter)world, pos);
                    do {
                        f = Direction.from3DDataValue((int)(f.get3DDataValue() + 1));
                    } while (!this.canRotateToTopOrBottom() && f.getAxis() == Direction.Axis.Y);
                    this.setRotation(world, pos, f);
                }
                PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(AbstractPneumaticCraftBlockEntity::onBlockRotated);
            }
            return true;
        }
        return false;
    }

    protected boolean rotateForgeWay() {
        return true;
    }

    protected boolean rotateCustom(Level world, BlockPos pos, BlockState state, Direction side) {
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos tilePos) {
        if (!world.isClientSide()) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> pncBE.onNeighborTileUpdate(tilePos));
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.isClientSide()) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> pncBE.onNeighborBlockUpdate(fromPos));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag flag) {
        EntityBlock eb;
        BlockEntity te;
        AbstractPneumaticCraftBlock abstractPneumaticCraftBlock;
        int savedAir = (Integer)stack.getOrDefault(ModDataComponents.AIR, (Object)0);
        if (savedAir != 0) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.air", Integer.toString(savedAir)).withStyle(ChatFormatting.GREEN));
        }
        ModDataComponents.TANK_COMPONENTS.forEach(component -> {
            FluidStack fluidStack;
            SimpleFluidContent content = (SimpleFluidContent)stack.get(component);
            if (content != null && !(fluidStack = content.copy()).isEmpty()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.fluid", new Object[0]).append(fluidStack.getAmount() + "mB ").append(fluidStack.getHoverName()).withStyle(ChatFormatting.GREEN));
            }
        });
        this.addExtraInformation(stack, context, curInfo, flag);
        if (ClientUtils.hasShiftDown() && (abstractPneumaticCraftBlock = this) instanceof EntityBlock && (te = (eb = (EntityBlock)abstractPneumaticCraftBlock).newBlockEntity(BlockPos.ZERO, this.defaultBlockState())) instanceof AbstractAirHandlingBlockEntity) {
            AbstractAirHandlingBlockEntity pneumatic = (AbstractAirHandlingBlockEntity)te;
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxPressure", Float.valueOf(pneumatic.getDangerPressure())).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        AbstractPneumaticCraftBlock abstractPneumaticCraftBlock = this;
        if (abstractPneumaticCraftBlock instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)abstractPneumaticCraftBlock;
            BlockEntity be = eb.newBlockEntity(BlockPos.ZERO, this.defaultBlockState());
            if (be instanceof ISerializableTanks) {
                ISerializableTanks st = (ISerializableTanks)be;
                list.addAll(st.getSerializableTanks().keySet());
            }
            if (be instanceof IRedstoneControl) {
                list.add(ModDataComponents.SAVED_REDSTONE_CONTROLLER.get());
            }
            if (be instanceof ISideConfigurable) {
                list.add(ModDataComponents.SAVED_SIDE_CONFIG.get());
            }
            if (be instanceof AbstractAirHandlingBlockEntity) {
                list.add(ModDataComponents.AIR.get());
            }
            if (be instanceof IUpgradeHolder) {
                list.add(ModDataComponents.ITEM_UPGRADES.get());
            }
        }
    }

    protected void addExtraInformation(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag flag) {
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return this instanceof IBlockComparatorSupport;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof IComparatorSupport) {
            IComparatorSupport comp = (IComparatorSupport)blockEntity;
            n = comp.getComparatorValue();
        } else {
            n = 0;
        }
        return n;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> {
                NonNullList drops = NonNullList.create();
                pncBE.getContentsToDrop((NonNullList<ItemStack>)drops);
                drops.forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, world, pos));
                if (!pncBE.shouldPreserveStateOnBreak()) {
                    PneumaticRegistry.getInstance().getMiscHelpers().playMachineBreakEffect((BlockEntity)pncBE);
                }
            });
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (stateIn.hasProperty((Property)AbstractPneumaticCraftBlock.connectionProperty(facing))) {
            BlockEntity ourTE = worldIn.getBlockEntity(currentPos);
            if (ourTE != null && PNCCapabilities.getAirHandler(ourTE, facing).isPresent()) {
                BlockEntity te = worldIn.getBlockEntity(currentPos.relative(facing));
                boolean b = te != null && PNCCapabilities.getAirHandler(te, facing.getOpposite()).isPresent();
                stateIn = (BlockState)stateIn.setValue((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(b));
            } else {
                stateIn = (BlockState)stateIn.setValue((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(false));
            }
            return stateIn;
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return state.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO).isEmpty();
    }

    static void removeBlockSneakWrenched(Level world, BlockPos pos) {
        if (!world.isClientSide()) {
            world.removeBlock(pos, false);
        }
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            AbstractPneumaticCraftBlockEntity base;
            ServerPlayer sp = (ServerPlayer)player;
            if (!(player instanceof FakePlayer) && te instanceof AbstractPneumaticCraftBlockEntity && !(base = (AbstractPneumaticCraftBlockEntity)te).shouldPreserveStateOnBreak()) {
                ModCriterionTriggers.MACHINE_VANDAL.get().trigger(sp);
            }
        }
        super.playerDestroy(worldIn, player, pos, state, te, stack);
    }
}

