/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class RangeManager {
    private final BlockEntity te;
    private final int renderColour;
    private int range = 0;
    private boolean showRange = false;
    private BoundingBox extents;
    private Supplier<BoundingBox> extentsGenerator;
    private Set<BlockPos> frame;

    public RangeManager(BlockEntity te, int renderColour) {
        this.te = te;
        this.renderColour = renderColour;
        this.extentsGenerator = () -> new BoundingBox(te.getBlockPos()).inflatedBy(this.range);
        this.setRange(1);
    }

    public RangeManager withCustomExtents(Supplier<BoundingBox> generator) {
        this.extentsGenerator = generator;
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int newRange) {
        if (newRange != this.range) {
            this.range = newRange;
            this.extents = this.extentsGenerator.get();
            Set<Object> set = this.frame = this.te.getLevel() != null && this.te.getLevel().isClientSide() ? RangeManager.getFrame(this.extents) : Set.of();
            if (this.shouldShowRange() && this.te.getLevel() != null && this.te.getLevel().isClientSide()) {
                this.toggleShowRange();
                this.toggleShowRange();
            }
        }
    }

    public void toggleShowRange() {
        boolean bl = this.showRange = !this.showRange;
        if (this.te.getLevel() != null && this.te.getLevel().isClientSide()) {
            if (this.showRange) {
                AreaRenderManager.getInstance().showArea(this.frame, this.renderColour, this.te, false);
            } else {
                AreaRenderManager.getInstance().removeHandlers(this.te);
            }
        }
    }

    public boolean shouldShowRange() {
        return this.showRange;
    }

    public BoundingBox getExtents() {
        return this.extents;
    }

    public AABB getExtentsAsAABB() {
        return new AABB((double)this.extents.minX(), (double)this.extents.minY(), (double)this.extents.minZ(), (double)this.extents.maxX(), (double)this.extents.maxY(), (double)this.extents.maxZ());
    }

    public static Set<BlockPos> getFrame(BlockPos pos, int range) {
        return RangeManager.getFrame(new BoundingBox(pos).inflatedBy(range));
    }

    public static Set<BlockPos> getFrame(BoundingBox extents) {
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        int minX = extents.minX();
        int minY = extents.minY();
        int minZ = extents.minZ();
        int maxX = extents.maxX();
        int maxY = extents.maxY();
        int maxZ = extents.maxZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    res.add(new BlockPos(x, y, z));
                }
            }
        }
        return res;
    }
}

