/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.inventory.ThermoPlantMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.RecipeCaches;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ThermoPlantBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<ThermoPlantBlockEntity>,
ISerializableTanks,
IAutoFluidEjecting,
MenuProvider,
IComparatorSupport,
IHeatExchangingTE {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 6000;
    private static final double MAX_SPEED_UP = 2.5;
    private static final AcceptabilityCache<Item> acceptedItemCache = new AcceptabilityCache();
    private static final AcceptabilityCache<Fluid> acceptedFluidCache = new AcceptabilityCache();
    @GuiSynced
    @DescSynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    @GuiSynced
    public final RedstoneController<ThermoPlantBlockEntity> rsController = new RedstoneController<ThermoPlantBlockEntity>(this);
    @GuiSynced
    private float craftingProgress;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public int minTemperature;
    @GuiSynced
    public int maxTemperature;
    @GuiSynced
    public TPProblem problem = TPProblem.OK;
    @DescSynced
    private boolean didWork;
    @GuiSynced
    private String currentRecipeIdSynced = "";
    private ThermoPlantRecipe currentRecipe;
    private boolean searchForRecipe = true;
    private final ItemStackHandler inputItemHandler = new InputItemHandler(this);
    private final ItemStackHandler outputItemHandler = new BaseItemStackHandler(this, 1);
    private final ThermopneumaticInvWrapper invWrapper = new ThermopneumaticInvWrapper((IItemHandler)this.inputItemHandler, (IItemHandler)this.outputItemHandler);
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();
    private double airUsage;

    public ThermoPlantBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.THERMOPNEUMATIC_PROCESSING_PLANT.get(), pos, state, PressureTier.TIER_ONE_HALF, 3000, 4);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return this.getRotation().getOpposite() != dir && dir != Direction.UP;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.inputTank.tick();
        this.outputTank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.didWork && this.nonNullLevel().random.nextBoolean()) {
            ClientUtils.emitParticles(this.nonNullLevel(), this.getBlockPos(), (ParticleOptions)ParticleTypes.SMOKE, 0.9);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.problem = TPProblem.OK;
        ThermoPlantRecipe prevRecipe = this.currentRecipe;
        if (this.searchForRecipe) {
            RecipeCaches.THERMO_PLANT.getCachedRecipe(this::findApplicableRecipe, this::genIngredientHash).ifPresentOrElse(holder -> {
                this.currentRecipe = (ThermoPlantRecipe)holder.value();
                this.currentRecipeIdSynced = holder.id().toString();
            }, () -> {
                this.currentRecipe = null;
                this.currentRecipeIdSynced = "";
            });
            this.searchForRecipe = false;
        }
        if (prevRecipe != this.currentRecipe) {
            this.nonNullLevel().updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
        this.didWork = false;
        if (this.currentRecipe != null) {
            if (this.getInputTank().getFluidAmount() < this.currentRecipe.getInputFluidAmount()) {
                this.problem = TPProblem.NOT_ENOUGH_FLUID;
            } else if (this.heatExchanger.getTemperature() > (double)this.currentRecipe.getOperatingTemperature().getMax()) {
                this.problem = TPProblem.TOO_HOT;
            } else if (this.heatExchanger.getTemperature() < (double)this.currentRecipe.getOperatingTemperature().getMin()) {
                this.problem = TPProblem.TOO_COLD;
            } else if (this.rsController.shouldRun() && this.hasEnoughPressure()) {
                this.runOneCycle();
            }
        } else {
            this.problem = TPProblem.NO_RECIPE;
            this.craftingProgress = 0.0f;
            this.minTemperature = 0;
            this.maxTemperature = 0;
            this.requiredPressure = 0.0f;
        }
    }

    private void runOneCycle() {
        float speedBoost = (float)(this.minTemperature > 0 ? Math.min(2.5, this.heatExchanger.getTemperature() / (double)this.minTemperature) : 1.0);
        if (this.craftingProgress < 6000.0f) {
            float progressInc = speedBoost * this.currentRecipe.getRecipeSpeed() * 100.0f;
            this.craftingProgress += progressInc;
            float progressDivider = progressInc / 6000.0f;
            this.airUsage += (double)((float)this.currentRecipe.airUsed() * progressDivider * speedBoost * this.currentRecipe.getAirUseMultiplier());
            if (this.airUsage > 1.0) {
                int i = (int)this.airUsage;
                this.addAir(-i);
                this.airUsage -= (double)i;
            }
            this.heatExchanger.addHeat(-this.currentRecipe.heatUsed(this.heatExchanger.getAmbientTemperature()) * (double)speedBoost * 0.75 * (double)progressDivider);
        }
        if (this.craftingProgress >= 6000.0f) {
            int filled = this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.SIMULATE);
            ItemStack excess = this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().copy(), true);
            if (filled == this.currentRecipe.getOutputFluid().getAmount() && excess.isEmpty()) {
                this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().copy(), false);
                this.inputTank.drain(this.currentRecipe.getInputFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.inputItemHandler.extractItem(0, this.getInputItemCount(), false);
                this.craftingProgress -= 6000.0f;
            } else {
                this.problem = TPProblem.OUTPUT_BLOCKED;
            }
        }
        this.didWork = this.problem == TPProblem.OK;
    }

    private int getInputItemCount() {
        if (this.currentRecipe != null) {
            ItemStack[] stacks = this.currentRecipe.getInputItem().map(Ingredient::getItems).orElse(new ItemStack[0]);
            return stacks.length > 0 ? stacks[0].getCount() : 0;
        }
        return 0;
    }

    private boolean hasEnoughPressure() {
        if (this.getMinWorkingPressure() == 0.0f) {
            return true;
        }
        if (this.getMinWorkingPressure() > 0.0f) {
            return this.getPressure() >= this.getMinWorkingPressure();
        }
        return this.getPressure() <= this.getMinWorkingPressure();
    }

    private Optional<RecipeHolder<ThermoPlantRecipe>> findApplicableRecipe() {
        for (RecipeHolder holder : ModRecipeTypes.getRecipes(this.level, ModRecipeTypes.THERMO_PLANT)) {
            ThermoPlantRecipe recipe = (ThermoPlantRecipe)holder.value();
            if (!recipe.matches(this.inputTank.getFluid(), this.inputItemHandler.getStackInSlot(0))) continue;
            this.requiredPressure = recipe.getRequiredPressure();
            this.minTemperature = recipe.getOperatingTemperature().getMin();
            this.maxTemperature = recipe.getOperatingTemperature().getMax();
            return Optional.of(holder);
        }
        return Optional.empty();
    }

    public IFluidTank getInputTank() {
        return this.inputTank;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.fluidHandler;
    }

    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 6000.0;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inputItemHandler.serializeNBT(provider));
        tag.put("Output", (Tag)this.outputItemHandler.serializeNBT(provider));
        tag.putFloat("craftingProgress", this.craftingProgress);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inputItemHandler.deserializeNBT(provider, tag.getCompound("Items"));
        this.outputItemHandler.deserializeNBT(provider, tag.getCompound("Output"));
        this.craftingProgress = tag.getFloat("craftingProgress");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        FluidStack moved;
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("dump") && !(moved = shiftHeld ? this.inputTank.drain(this.inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)this.inputTank, (int)this.inputTank.getFluidAmount(), (boolean)true)).isEmpty()) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, this.worldPosition, 1.0f, 1.0f, false), player);
        }
    }

    @Override
    public IItemHandler getItemHandler(@javax.annotation.Nullable Direction dir) {
        return this.invWrapper;
    }

    @Override
    public RedstoneController<ThermoPlantBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.INPUT_TANK_1.get(), this.inputTank, ModDataComponents.OUTPUT_TANK.get(), this.outputTank);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ThermoPlantMenu(i, playerInventory, this.getBlockPos());
    }

    public IItemHandler getOutputInventory() {
        return this.outputItemHandler;
    }

    @Override
    public int getComparatorValue() {
        if (this.currentRecipe == null || this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.SIMULATE) < this.currentRecipe.getOutputFluid().getAmount() || !this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().copy(), true).isEmpty()) {
            return 0;
        }
        return 15;
    }

    public static void clearCachedItemsAndFluids() {
        acceptedItemCache.clear();
        acceptedFluidCache.clear();
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    public int genIngredientHash() {
        return Objects.hash(FluidStack.hashFluidAndComponents((FluidStack)this.inputTank.getFluid()), ItemStack.hashItemAndComponents((ItemStack)this.inputItemHandler.getStackInSlot(0)));
    }

    public IItemHandler getInputItemHandler() {
        return this.inputItemHandler;
    }

    private class ThermopneumaticFluidTankInput
    extends SmartSyncTank {
        ThermopneumaticFluidTankInput(int capacity) {
            super(ThermoPlantBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack fluid) {
            return fluid.isEmpty() || acceptedFluidCache.isAcceptable(fluid.getFluid(), () -> ModRecipeTypes.THERMO_PLANT.get().stream(ThermoPlantBlockEntity.this.level).anyMatch(r -> ((ThermoPlantRecipe)r.value()).testFluid(fluid)));
        }

        @Override
        protected void onContentsChanged(FluidStack prevStack) {
            super.onContentsChanged(prevStack);
            if (!FluidStack.isSameFluidSameComponents((FluidStack)prevStack, (FluidStack)this.getFluid()) || ThermoPlantBlockEntity.this.currentRecipe == null && this.getFluidAmount() > prevStack.getAmount() || ThermoPlantBlockEntity.this.currentRecipe != null && this.getFluidAmount() < prevStack.getAmount()) {
                ThermoPlantBlockEntity.this.searchForRecipe = true;
            }
        }
    }

    public static enum TPProblem implements ITranslatableEnum
    {
        OK(""),
        NO_RECIPE("noRecipe"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        TOO_HOT("tooMuchHeat"),
        TOO_COLD("notEnoughHeat"),
        OUTPUT_BLOCKED("outputBlocked");

        private final String key;

        private TPProblem(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems." + this.key;
        }
    }

    private class InputItemHandler
    extends BaseItemStackHandler {
        private Item prev;

        public InputItemHandler(BlockEntity te) {
            super(te, 1);
            this.prev = null;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.isEmpty() || acceptedItemCache.isAcceptable(stack.getItem(), () -> ModRecipeTypes.THERMO_PLANT.get().stream(ThermoPlantBlockEntity.this.level).anyMatch(r -> ((ThermoPlantRecipe)r.value()).testItem(stack)));
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.getStackInSlot(0).getItem() != this.prev) {
                ThermoPlantBlockEntity.this.searchForRecipe = true;
            }
            this.prev = this.getStackInSlot(0).getItem();
        }
    }

    private class ThermopneumaticInvWrapper
    implements IItemHandler {
        private final IItemHandler input;
        private final IItemHandler output;

        ThermopneumaticInvWrapper(IItemHandler input, IItemHandler output) {
            this.input = input;
            this.output = output;
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.input.getStackInSlot(0) : this.output.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? ThermoPlantBlockEntity.this.inputItemHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? ThermoPlantBlockEntity.this.outputItemHandler.extractItem(0, amount, simulate) : ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.input.getSlotLimit(0) : this.output.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.input.isItemValid(0, stack) : this.output.isItemValid(0, stack);
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        final IFluidTank[] tanks;

        ThermopneumaticFluidHandler() {
            this.tanks = new IFluidTank[]{ThermoPlantBlockEntity.this.inputTank, ThermoPlantBlockEntity.this.outputTank};
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return ThermoPlantBlockEntity.this.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return FluidStack.isSameFluidSameComponents((FluidStack)ThermoPlantBlockEntity.this.outputTank.getFluid(), (FluidStack)resource) ? ThermoPlantBlockEntity.this.outputTank.drain(resource.getAmount(), doDrain) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return ThermoPlantBlockEntity.this.outputTank.drain(maxDrain, doDrain);
        }
    }
}

