/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.SentryTurretMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.StringFilterEntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SentryTurretBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<SentryTurretBlockEntity>,
IGUITextFieldSensitive,
MenuProvider {
    private static final int INVENTORY_SIZE = 4;
    private static final String NBT_ENTITY_FILTER = "entityFilter";
    private static final String FAKE_NAME = "Sentry Turret";
    private static final GameProfile FAKE_PROFILE = UUIDUtil.createOfflineProfile((String)"Sentry Turret");
    private final ItemStackHandler inventory = new TurretItemStackHandler(this);
    private Minigun minigun;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();
    private Vec3 tileVec;
    private UUID ownerId;
    @GuiSynced
    private String entityFilter = "@mob";
    @GuiSynced
    private final RedstoneController<SentryTurretBlockEntity> rsController = new RedstoneController<SentryTurretBlockEntity>(this);
    @DescSynced
    private double range;
    private double rangeSq;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack = ItemStack.EMPTY;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    @DescSynced
    private float idleYaw;
    @DescSynced
    private int nMufflers;

    public SentryTurretBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.SENTRY_TURRET.get(), pos, state, 4);
    }

    @Override
    public void tickServer() {
        LivingEntity target;
        super.tickServer();
        if (this.getMinigun().getAttackTarget() == null && this.rsController.shouldRun()) {
            this.getMinigun().setSweeping(true);
            if ((this.nonNullLevel().getGameTime() & 0xFL) == 0L) {
                List entities = this.nonNullLevel().getEntitiesOfClass(LivingEntity.class, this.getTargetingBoundingBox(), (Predicate)((Object)this.entitySelector));
                if (!entities.isEmpty()) {
                    entities.sort(new EntityDistanceComparator(this.getBlockPos()));
                    this.getMinigun().setAttackTarget((LivingEntity)entities.getFirst());
                    this.targetEntityId = this.getMinigun().getAttackTarget().getId();
                } else if (this.targetEntityId > 0) {
                    this.getMinigun().setReturning(true);
                    this.targetEntityId = -1;
                }
            }
        } else {
            this.getMinigun().setSweeping(false);
        }
        if ((target = this.getMinigun().getAttackTarget()) != null) {
            if (this.rsController.shouldRun() && this.entitySelector.test((Entity)target)) {
                if ((this.nonNullLevel().getGameTime() & 7L) == 0L) {
                    this.getFakePlayer().setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5);
                    if (this.getMinigun().tryFireMinigun((Entity)target).ammoUsedUp()) {
                        this.clearEmptyAmmo();
                    }
                }
            } else {
                this.getMinigun().setAttackTarget(null);
                this.getMinigun().minigunYaw = this.idleYaw;
                this.targetEntityId = -1;
            }
        }
    }

    @Override
    public void tickCommonPost() {
        super.tickCommonPost();
        this.getMinigun().setIdleYaw(this.idleYaw);
        this.getMinigun().tick((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5);
    }

    private void clearEmptyAmmo() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!(stack.getItem() instanceof AbstractGunAmmoItem) || stack.getDamageValue() < stack.getMaxDamage()) continue;
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.entityFilter = (String)componentInput.getOrDefault(ModDataComponents.ENTITY_FILTER, (Object)"@mob");
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ModDataComponents.ENTITY_FILTER, (Object)this.entityFilter);
    }

    private boolean canTurretSeeEntity(Entity entity) {
        Vec3 entityVec = new Vec3(entity.getX() + (double)(entity.getBbWidth() / 2.0f), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ() + (double)(entity.getBbWidth() / 2.0f));
        ClipContext ctx = new ClipContext(entityVec, this.tileVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        BlockHitResult trace = this.nonNullLevel().clip(ctx);
        return trace.getBlockPos().equals((Object)this.getBlockPos());
    }

    private AABB getTargetingBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(this.getRange());
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.tileVec = Vec3.atCenterOf((Vec3i)this.getBlockPos());
            this.nMufflers = this.getUpgrades(ModUpgrades.MUFFLER.get());
            this.updateAmmo();
            this.onFilterChanged(this.entityFilter);
        }
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.nonNullLevel().getEntity(this.targetEntityId);
        if (entity instanceof LivingEntity) {
            this.getMinigun().setAttackTarget((LivingEntity)entity);
        } else if (this.getMinigun().getAttackTarget() != null) {
            this.getMinigun().setAttackTarget(null);
            this.getMinigun().setReturning(true);
        }
    }

    public void setOwner(ServerPlayer player) {
        this.ownerId = player.getUUID();
        this.setChanged();
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret(this.nonNullLevel().isClientSide ? null : this.getFakePlayer());
            this.minigun.setWorld(this.getLevel());
        }
        return this.minigun;
    }

    private Player getFakePlayer() {
        return FakePlayerFactory.get((ServerLevel)((ServerLevel)this.getLevel()), (GameProfile)FAKE_PROFILE);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
        tag.putString(NBT_ENTITY_FILTER, this.entityFilter);
        tag.putFloat("idleYaw", this.idleYaw);
        if (this.ownerId != null) {
            tag.putUUID("ownerId", this.ownerId);
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        this.idleYaw = tag.getFloat("idleYaw");
        this.setText(0, tag.getString(NBT_ENTITY_FILTER));
        if (tag.contains("ownerId")) {
            this.ownerId = tag.getUUID("ownerId");
        }
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public RedstoneController<SentryTurretBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new SentryTurretMenu(i, playerInventory, this.getBlockPos());
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = Minigun.clampYaw(idleYaw);
    }

    private void updateAmmo() {
        ItemStack ammo = ItemStack.EMPTY;
        for (int i = 0; i < this.inventory.getSlots() && (ammo = this.inventory.getStackInSlot(i)).isEmpty(); ++i) {
        }
        this.getMinigun().setAmmoStack(ammo);
        this.needRangeRecalc();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.getLevel() != null) {
            this.needRangeRecalc();
            if (!this.getLevel().isClientSide) {
                this.nMufflers = this.getUpgrades(ModUpgrades.MUFFLER.get());
            }
        }
        this.getMinigun().setInfiniteAmmo(this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0);
    }

    private double getRange() {
        if (this.range < 0.0) {
            this.recalcRange();
        }
        return this.range;
    }

    private double getRangeSquared() {
        if (this.rangeSq < 0.0) {
            this.recalcRange();
        }
        return this.rangeSq;
    }

    private void recalcRange() {
        this.range = 16 + Math.min(16, this.getUpgrades(ModUpgrades.RANGE.get()));
        ItemStack ammoStack = this.getMinigun().getAmmoStack();
        Item item = ammoStack.getItem();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
            this.range *= (double)ammo.getRangeMultiplier(ammoStack);
        }
        this.rangeSq = this.range * this.range;
    }

    private void needRangeRecalc() {
        this.rangeSq = -1.0;
        this.range = -1.0;
    }

    @Override
    public float getMuffledVolume(float baseVolume) {
        return ModUpgrades.getMuffledVolume(baseVolume, this.nMufflers);
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        if (this.level != null && !this.level.isClientSide) {
            this.onFilterChanged(text);
            if (this.minigun != null) {
                this.minigun.setAttackTarget(null);
            }
        }
    }

    private void onFilterChanged(String text) {
        this.entitySelector.setFilter(text);
        this.setChanged();
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    private class TurretItemStackHandler
    extends BaseItemStackHandler {
        TurretItemStackHandler(BlockEntity te) {
            super(te, 4);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SentryTurretBlockEntity.this.updateAmmo();
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() instanceof AbstractGunAmmoItem;
        }
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        public boolean test(Entity entity) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator() || this.isExcludedBySecurityStations(player) || this.isProtectedOwner(player))) {
                return false;
            }
            return super.test((Object)entity) && this.inRange(entity) && SentryTurretBlockEntity.this.canTurretSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetweenSq((Vec3i)new BlockPos(SentryTurretBlockEntity.this.getBlockPos().getX(), SentryTurretBlockEntity.this.getBlockPos().getY(), SentryTurretBlockEntity.this.getBlockPos().getZ()), entity.getX(), entity.getY(), entity.getZ()) <= SentryTurretBlockEntity.this.getRangeSquared();
        }

        private boolean isProtectedOwner(Player player) {
            return player.getUUID().equals(SentryTurretBlockEntity.this.ownerId) && SentryTurretBlockEntity.this.entityFilter.isEmpty();
        }

        private boolean isExcludedBySecurityStations(Player player) {
            Iterator iterator = SecurityStationBlockEntity.getSecurityStations(SentryTurretBlockEntity.this.getLevel(), SentryTurretBlockEntity.this.getBlockPos(), false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (((SecurityStationBlockEntity)iterator.next()).doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        MinigunSentryTurret(Player fakePlayer) {
            super(fakePlayer, true);
        }

        @Override
        public boolean isMinigunActivated() {
            return SentryTurretBlockEntity.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            if (!this.world.isClientSide) {
                SentryTurretBlockEntity.this.activated = activated;
            }
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!this.world.isClientSide) {
                SentryTurretBlockEntity.this.minigunColorStack = ammo;
            }
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(SentryTurretBlockEntity.this.minigunColorStack);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            this.world.playSound(null, SentryTurretBlockEntity.this.getBlockPos(), soundName, SoundSource.BLOCKS, volume, pitch);
        }

        @Override
        public Vec3 getMuzzlePosition() {
            Vec3 centre = Vec3.atCenterOf((Vec3i)SentryTurretBlockEntity.this.getPosition());
            LivingEntity target = SentryTurretBlockEntity.this.minigun.getAttackTarget();
            if (target == null) {
                return null;
            }
            Vec3 offset = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(centre).add(0.0, 0.5, 0.0).normalize().scale(1.5);
            return centre.add(offset);
        }

        @Override
        public Vec3 getLookAngle() {
            return Vec3.directionFromRotation((float)this.minigunPitch, (float)this.minigunYaw).normalize();
        }

        @Override
        public float getParticleScale() {
            return 1.0f;
        }

        @Override
        public void setSweeping(boolean sweeping) {
            SentryTurretBlockEntity.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return SentryTurretBlockEntity.this.sweeping;
        }

        @Override
        public PacketPlayMovingSound.MovingSoundFocus getSoundSource() {
            return PacketPlayMovingSound.MovingSoundFocus.of(SentryTurretBlockEntity.this);
        }

        @Override
        public boolean isValid() {
            return !SentryTurretBlockEntity.this.isRemoved();
        }

        @Override
        public int getUpgrades(PNCUpgrade upgrade) {
            return SentryTurretBlockEntity.this.getUpgrades(upgrade);
        }
    }
}

