/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAILiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;

public class ProgWidgetLiquidExport
extends ProgWidgetInventoryBase
implements ILiquidFiltered,
ILiquidExport {
    public static final MapCodec<ProgWidgetLiquidExport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetLiquidExport.invParts(builder).and((App)Codec.BOOL.optionalFieldOf("place_fluid_blocks", (Object)false).forGetter(ProgWidgetLiquidExport::isPlacingFluidBlocks)).apply((Applicative)builder, ProgWidgetLiquidExport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetLiquidExport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetLiquidExport::isPlacingFluidBlocks, ProgWidgetLiquidExport::new);
    private boolean placeFluidBlocks;

    public ProgWidgetLiquidExport() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT, false);
    }

    private ProgWidgetLiquidExport(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields, boolean placeFluidBlocks) {
        super(pos, invBaseFields);
        this.placeFluidBlocks = placeFluidBlocks;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetLiquidExport(this.getPosition(), this.invBaseFields().copy(), this.placeFluidBlocks);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_EX;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.LIQUID_FILTER.get());
    }

    @Override
    public boolean isFluidValid(Fluid fluid) {
        return ProgWidgetLiquidFilter.isLiquidValid(fluid, this, 1);
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAILiquidExport<ProgWidgetInventoryBase>(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.ORANGE;
    }

    @Override
    public void setPlaceFluidBlocks(boolean placeFluidBlocks) {
        this.placeFluidBlocks = placeFluidBlocks;
    }

    @Override
    public boolean isPlacingFluidBlocks() {
        return this.placeFluidBlocks;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.LIQUID_EXPORT.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetLiquidExport that = (ProgWidgetLiquidExport)o;
        return this.baseEquals(that) && this.placeFluidBlocks == that.placeFluidBlocks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.placeFluidBlocks);
    }
}

